/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;

@ExperimentalApi
public class DefaultIssueEventBundle
implements IssueEventBundle {
    private final Collection<JiraIssueEvent> events;
    private final boolean sendEmailNotification;

    private DefaultIssueEventBundle(Collection<? extends JiraIssueEvent> events, boolean sendEmailNotification) {
        this.events = ImmutableList.copyOf(events);
        this.sendEmailNotification = sendEmailNotification;
    }

    @Nonnull
    public static DefaultIssueEventBundle create(@Nonnull Collection<? extends JiraIssueEvent> events) {
        return new DefaultIssueEventBundle(events, true);
    }

    @Nonnull
    public static DefaultIssueEventBundle createDisallowingEmailNotifications(@Nonnull Collection<JiraIssueEvent> events) {
        return new DefaultIssueEventBundle(events, false);
    }

    @Nonnull
    public Collection<JiraIssueEvent> getEvents() {
        return this.events;
    }

    public boolean doesSendEmailNotification() {
        return this.sendEmailNotification;
    }
}

