/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.event.config.ApplicationPropertyChangeEvent;
import com.atlassian.jira.util.JiraKeyUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class ProjectKeyRegexChangeListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectKeyRegexChangeListener.class);

    @EventListener
    public static void onApplicationPropertyChange(ApplicationPropertyChangeEvent event) {
        try {
            Map params = event.getParams();
            ApplicationPropertyMetadata metadata = (ApplicationPropertyMetadata)params.get("metadata");
            if ("jira.projectkey.pattern".equals(metadata.getKey())) {
                log.info("Resetting the issue key matcher");
                JiraKeyUtils.resetKeyMatcher();
            }
        }
        catch (Exception e) {
            log.error("Unable to decide whether to reset the project key matcher because the event doesn't seem to contain the correct metadata");
        }
    }
}

