/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.favourites;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.favourites.FavouritesStore;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultFavouritesManager
implements FavouritesManager<SharedEntity> {
    private final FavouritesStore store;
    private final SharedEntityAccessor.Factory sharedEntityAccessorFactory;
    private final ShareManager shareManager;

    public DefaultFavouritesManager(FavouritesStore store, SharedEntityAccessor.Factory sharedEntityAccessorFactory, ShareManager shareManager) {
        this.store = store;
        this.sharedEntityAccessorFactory = sharedEntityAccessorFactory;
        this.shareManager = shareManager;
    }

    public void addFavourite(ApplicationUser user, SharedEntity entity) throws PermissionException {
        this.validateInput(user, entity);
        this.checkPermissions(user, entity);
        if (this.store.addFavourite(user, entity)) {
            this.adjustFavouriteCount(entity, 1);
        }
    }

    public void addFavouriteInPosition(ApplicationUser user, SharedEntity entity, long position) throws PermissionException {
        this.validateInput(user, entity);
        this.checkPermissions(user, entity);
        if (this.store.addFavourite(user, entity)) {
            this.adjustFavouriteCount(entity, 1);
            this.reorderFavourites(user, entity, new InsertInPositionReorderCommand((int)position));
        }
    }

    private void adjustFavouriteCount(SharedEntity entity, int incrementCount) {
        SharedEntityAccessor countAdjuster = this.sharedEntityAccessorFactory.getSharedEntityAccessor(entity.getEntityType());
        if (countAdjuster != null) {
            countAdjuster.adjustFavouriteCount(entity, incrementCount);
        }
    }

    public void removeFavourite(ApplicationUser user, SharedEntity entity) {
        this.validateInput(user, entity);
        if (this.store.removeFavourite(user, entity)) {
            this.adjustFavouriteCount(entity, -1);
        }
    }

    public boolean isFavourite(ApplicationUser user, SharedEntity entity) throws PermissionException {
        this.validateInput(user, entity);
        this.checkPermissions(user, entity);
        return this.store.isFavourite(user, entity);
    }

    public Collection<Long> getFavouriteIds(ApplicationUser user, SharedEntity.TypeDescriptor<SharedEntity> entityType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entity type", entityType);
        return this.store.getFavouriteIds(user, entityType);
    }

    public void removeFavouritesForUser(ApplicationUser user, SharedEntity.TypeDescriptor<SharedEntity> entityType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entity type", entityType);
        Collection<Long> ids = this.getFavouriteIds(user, entityType);
        for (Long id : ids) {
            this.removeFavourite(user, (SharedEntity)new SharedEntity.Identifier(id, entityType, user));
        }
    }

    public void removeFavouritesForEntityDelete(SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity type", (Object)entity.getEntityType());
        Assertions.notNull((String)"entity Id", (Object)entity.getId());
        this.store.removeFavouritesForEntity(entity);
    }

    public void increaseFavouriteSequence(ApplicationUser user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                CollectionReorderer.increasePosition(favouriteEntities, entity);
            }
        });
    }

    public void decreaseFavouriteSequence(ApplicationUser user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                CollectionReorderer.decreasePosition(favouriteEntities, entity);
            }
        });
    }

    public void moveToStartFavouriteSequence(ApplicationUser user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                CollectionReorderer.moveToStart(favouriteEntities, entity);
            }
        });
    }

    public void moveToEndFavouriteSequence(ApplicationUser user, SharedEntity entity) throws PermissionException {
        this.reorderFavourites(user, entity, new FavouriteReordererCommand(){

            @Override
            public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
                CollectionReorderer.moveToEnd(favouriteEntities, entity);
            }
        });
    }

    void reorderFavourites(ApplicationUser user, SharedEntity entity, FavouriteReordererCommand favouriteReordererCommand) {
        this.validateInput(user, entity);
        Collection<Long> favIds = this.store.getFavouriteIds(user, entity.getEntityType());
        ArrayList<SharedEntity> dontHavePermission = new ArrayList<SharedEntity>();
        ArrayList<SharedEntity> favouriteEntities = new ArrayList<SharedEntity>();
        ArrayList<Long> deadFavourites = new ArrayList<Long>();
        SharedEntity targetEntity = null;
        SharedEntityAccessor sharedEntityAccessor = this.sharedEntityAccessorFactory.getSharedEntityAccessor(entity.getEntityType());
        for (Long favId : favIds) {
            SharedEntity favEntity = sharedEntityAccessor.getSharedEntity(favId);
            if (favEntity != null) {
                if (sharedEntityAccessor.hasPermissionToUse(user, favEntity)) {
                    favouriteEntities.add(favEntity);
                    if (!favEntity.getId().equals(entity.getId())) continue;
                    targetEntity = favEntity;
                    continue;
                }
                dontHavePermission.add(favEntity);
                continue;
            }
            deadFavourites.add(favId);
        }
        if (targetEntity != null) {
            favouriteReordererCommand.reorderFavourites(favouriteEntities, targetEntity);
        }
        favouriteEntities.addAll(dontHavePermission);
        this.removeDeadFavourites(user, deadFavourites, (SharedEntity.TypeDescriptor<SharedEntity>)entity.getEntityType());
        this.store.updateSequence(user, favouriteEntities);
    }

    private void removeDeadFavourites(ApplicationUser user, List<Long> deadFavourites, SharedEntity.TypeDescriptor<SharedEntity> entityType) {
        Iterator<Long> iterator = deadFavourites.iterator();
        while (iterator.hasNext()) {
            Long element;
            Long favId = element = iterator.next();
            SharedEntity.Identifier deadEntity = new SharedEntity.Identifier(favId, entityType, user);
            this.store.removeFavourite(user, (SharedEntity)deadEntity);
        }
    }

    private boolean hasUserPermissionToSeeEntity(ApplicationUser user, SharedEntity entity) {
        return this.shareManager.isSharedWith(user, entity);
    }

    private void validateInput(ApplicationUser user, SharedEntity entity) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity type", (Object)entity.getEntityType());
        Assertions.notNull((String)"entity Id", (Object)entity.getId());
    }

    private void checkPermissions(ApplicationUser user, SharedEntity entity) throws PermissionException {
        if (!this.hasUserPermissionToSeeEntity(user, entity)) {
            throw new PermissionException("User (" + user + ") does not have permission to see entity - " + entity.getEntityType() + ":" + entity.getId());
        }
    }

    static class InsertInPositionReorderCommand
    implements FavouriteReordererCommand {
        final int position;

        InsertInPositionReorderCommand(int position) {
            this.position = position;
        }

        @Override
        public void reorderFavourites(List<SharedEntity> favouriteEntities, SharedEntity entity) {
            CollectionReorderer.moveToPosition(favouriteEntities, favouriteEntities.size() - 1, this.position);
        }
    }

    static interface FavouriteReordererCommand {
        public void reorderFavourites(List<SharedEntity> var1, SharedEntity var2);
    }

    private static final class Count {
        private static final int INCREMENT = 1;
        private static final int DECREMENT = -1;

        private Count() {
        }
    }
}

