/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.help.ApplicationHelpSpaceProvider;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsApplicationKeyProvider;
import com.atlassian.jira.help.HelpUrlsLoader;
import com.atlassian.jira.help.HelpUrlsParser;
import com.atlassian.jira.help.HelpUrlsParserBuilderFactory;
import com.atlassian.jira.help.ImmutableHelpUrls;
import com.atlassian.jira.help.LocalHelpUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.resourcebundle.HelpResourceBundleLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHelpUrlsLoader
implements HelpUrlsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHelpUrlsLoader.class);
    private static final String DEFAULT_HELP_URL = "https://confluence.atlassian.com/display/JIRA/";
    private final JiraAuthenticationContext ctx;
    private final LocalHelpUrls localHelpUrls;
    private final I18nHelper.BeanFactory i18n;
    private final HelpUrlsParserBuilderFactory parserBuilderFactory;
    private final ApplicationHelpSpaceProvider applicationHelpSpaceProvider;
    private final HelpUrlsApplicationKeyProvider helpUrlsApplicationKeyProvider;
    private final HelpResourceBundleLoader helpResourceBundleLoader;

    public DefaultHelpUrlsLoader(HelpResourceBundleLoader helpResourceBundleLoader, JiraAuthenticationContext ctx, LocalHelpUrls localHelpUrls, I18nHelper.BeanFactory i18n, HelpUrlsParserBuilderFactory parserBuilderFactory, HelpUrlsApplicationKeyProvider helpUrlsApplicationKeyProvider, ApplicationHelpSpaceProvider applicationHelpSpaceProvider) {
        this.i18n = i18n;
        this.parserBuilderFactory = parserBuilderFactory;
        this.applicationHelpSpaceProvider = applicationHelpSpaceProvider;
        this.ctx = ctx;
        this.localHelpUrls = localHelpUrls;
        this.helpUrlsApplicationKeyProvider = helpUrlsApplicationKeyProvider;
        this.helpResourceBundleLoader = helpResourceBundleLoader;
    }

    @Override
    @Nonnull
    public HelpUrlsLoader.HelpUrlsLoaderKey keyForCurrentUser() {
        return new LoaderKey(this.ctx.getLocale(), this.helpUrlsApplicationKeyProvider.getApplicationKeyForUser());
    }

    @Override
    @Nonnull
    public HelpUrlsLoader.HelpUrlsLoaderKey keyForApplication(@Nonnull ApplicationKey applicationKey) {
        return new LoaderKey(this.ctx.getLocale(), applicationKey);
    }

    @Override
    public HelpUrls apply(HelpUrlsLoader.HelpUrlsLoaderKey input) {
        Assertions.notNull((Object)input);
        if (input instanceof LoaderKey) {
            LOG.debug("Loading help urls for key '{}'.", (Object)input);
            return this.apply((LoaderKey)input);
        }
        throw new IllegalArgumentException("'input' was not created by a call to keyForCurrentUser.");
    }

    private HelpUrls apply(LoaderKey key) {
        HelpUrls externalHelpUrls = this.getExternalHelpUrls(key);
        return new ImmutableHelpUrls(externalHelpUrls.getDefaultUrl(), Iterables.concat(this.localHelpUrls.load(), (Iterable)externalHelpUrls));
    }

    private HelpUrls getExternalHelpUrls(LoaderKey key) {
        if (this.helpUrlsApplicationKeyProvider.shouldParseLegacyHelpProperties()) {
            return this.createLegacyHelpUrlParser(key).parse(this.helpResourceBundleLoader.load(HelpResourceBundleLoader.Type.LEGACY_HELP, key.locale));
        }
        return this.createHelpUrlParser(key).parse(this.helpResourceBundleLoader.load(HelpResourceBundleLoader.Type.USER_HELP, key.locale), this.helpResourceBundleLoader.load(HelpResourceBundleLoader.Type.ADMIN_HELP, key.locale));
    }

    private HelpUrlsParser createLegacyHelpUrlParser(LoaderKey key) {
        return this.parserBuilderFactory.newBuilder().defaultUrl(DEFAULT_HELP_URL, this.i18n.getInstance(key.locale).getText("jira.help.paths.help.title")).build();
    }

    private HelpUrlsParser createHelpUrlParser(LoaderKey key) {
        return this.parserBuilderFactory.newBuilder().defaultUrl(DEFAULT_HELP_URL, this.i18n.getInstance(key.locale).getText("jira.help.paths.help.title")).applicationHelpSpace(this.applicationHelpSpaceProvider.getHelpSpace(key.applicationKey).orElse(this.applicationHelpSpaceProvider.getHelpSpace(ApplicationKeys.CORE))).build();
    }

    @VisibleForTesting
    static class LoaderKey
    implements HelpUrlsLoader.HelpUrlsLoaderKey {
        private final Locale locale;
        private final ApplicationKey applicationKey;

        @VisibleForTesting
        LoaderKey(Locale locale, ApplicationKey applicationKey) {
            this.locale = locale;
            this.applicationKey = applicationKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoaderKey loaderKey = (LoaderKey)o;
            if (this.locale != null ? !this.locale.equals(loaderKey.locale) : loaderKey.locale != null) {
                return false;
            }
            return !(this.applicationKey == null ? loaderKey.applicationKey != null : !this.applicationKey.equals((Object)loaderKey.applicationKey));
        }

        public int hashCode() {
            int result = this.locale != null ? this.locale.hashCode() : 0;
            result = 31 * result + (this.applicationKey != null ? this.applicationKey.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "LoaderKey{locale=" + this.locale + ", applicationKey=" + this.applicationKey + '}';
        }
    }
}

