/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

class ImmutableHelpUrl
implements HelpUrl {
    private final String url;
    private final String alt;
    private final String description;
    private final String key;
    private final boolean local;
    private final String title;

    ImmutableHelpUrl(String key, String url, String title, String alt, String description, boolean local) {
        this.key = (String)Assertions.notNull((String)"key", (Object)key);
        this.url = url;
        this.alt = alt;
        this.description = description;
        this.title = title;
        this.local = local;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableHelpUrl that = (ImmutableHelpUrl)o;
        if (this.local != that.local) {
            return false;
        }
        if (this.alt != null ? !this.alt.equals(that.alt) : that.alt != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.alt != null ? this.alt.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.local ? 1 : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("url", (Object)this.url).append("alt", (Object)this.alt).append("key", (Object)this.key).append("local", this.local).append("title", (Object)this.title).append("description", (Object)this.description).toString();
    }
}

