/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class JiraLocaleResolver
implements LocaleResolver {
    private final LocaleManager localeManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserManager userManager;

    public JiraLocaleResolver(LocaleManager localeManager, JiraAuthenticationContext jiraAuthenticationContext, UserManager userManager) {
        this.localeManager = localeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userManager = userManager;
    }

    public Locale getLocale(HttpServletRequest request) {
        return this.jiraAuthenticationContext.getLocale();
    }

    public Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    public Locale getLocale(UserKey userKey) {
        ApplicationUser user = this.userManager.getUserByKey(userKey.getStringValue());
        return this.localeManager.getLocaleFor(user);
    }

    public Set<Locale> getSupportedLocales() {
        return this.localeManager.getInstalledLocales();
    }
}

