/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupOverviewBuilder;
import com.atlassian.jira.imports.project.core.BackupOverviewImpl;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupProjectImpl;
import com.atlassian.jira.imports.project.core.BackupSystemInformationImpl;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.populator.BackupOverviewPopulator;
import com.atlassian.jira.imports.project.populator.CommentPopulator;
import com.atlassian.jira.imports.project.populator.CustomFieldPopulator;
import com.atlassian.jira.imports.project.populator.IssueIdPopulator;
import com.atlassian.jira.imports.project.populator.PluginVersionPopulator;
import com.atlassian.jira.imports.project.populator.ProjectComponentPopulator;
import com.atlassian.jira.imports.project.populator.ProjectPopulator;
import com.atlassian.jira.imports.project.populator.ProjectVersionPopulator;
import com.atlassian.jira.imports.project.populator.SystemInfoPopulator;
import com.atlassian.jira.plugin.PluginVersion;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupOverviewBuilderImpl
implements BackupOverviewBuilder {
    private static final Logger log = LoggerFactory.getLogger(BackupOverviewBuilderImpl.class);
    private final List<ExternalProject> projects = new ArrayList<ExternalProject>();
    private final List<PluginVersion> pluginVersions = new ArrayList<PluginVersion>();
    private final ListMultimap<String, Long> issueIds;
    private final Map<String, String> issueIdToKeyMap;
    private final Map<String, Integer> issueTextSystemFieldMaxLength;
    private final ListMultimap<String, ExternalVersion> versions = ArrayListMultimap.create();
    private final ListMultimap<String, ExternalComponent> components = ArrayListMultimap.create();
    private final List<BackupOverviewPopulator> overviewPopulators;
    private final List<ExternalCustomField> customFields;
    private final ListMultimap<String, BackupOverviewBuilder.ConfigurationContext> configurationContexts;
    private final ListMultimap<String, BackupOverviewBuilder.FieldConfigSchemeIssueType> fieldConfigSchemeIssueTypes;
    private final Map<String, ListMultimap<String, Object>> additionalData;
    private final Set<String> entities;
    private int entityCount;
    private String buildNumber;
    private String edition;
    private boolean unassignedIssuesAllowed;

    public BackupOverviewBuilderImpl() {
        this.issueIds = ArrayListMultimap.create();
        this.issueIdToKeyMap = new HashMap<String, String>();
        this.customFields = new ArrayList<ExternalCustomField>();
        this.configurationContexts = ArrayListMultimap.create();
        this.fieldConfigSchemeIssueTypes = ArrayListMultimap.create();
        this.entities = Sets.newHashSet();
        this.additionalData = Maps.newHashMap();
        this.overviewPopulators = new ArrayList<BackupOverviewPopulator>();
        this.registerOverviewPopulators();
        this.issueTextSystemFieldMaxLength = Maps.newHashMap();
    }

    public void addProject(ExternalProject project) {
        this.projects.add(project);
    }

    public void addPluginVersion(PluginVersion pluginVersion) {
        this.pluginVersions.add(pluginVersion);
    }

    public void addVersion(ExternalVersion version) {
        this.versions.put((Object)version.getProjectId(), (Object)version);
    }

    public void addComponent(ExternalComponent component) {
        this.components.put((Object)component.getProjectId(), (Object)component);
    }

    public void addIssue(ExternalIssue issue) {
        this.issueIds.put((Object)issue.getProject(), (Object)new Long(issue.getId()));
        this.issueIdToKeyMap.put(issue.getId(), issue.getKey());
        this.storeMaximumTextFieldLengthInIssue(issue.getId(), Math.max(StringUtils.length((String)issue.getDescription()), StringUtils.length((String)issue.getEnvironment())));
    }

    private void storeMaximumTextFieldLengthInIssue(String issueId, int fieldLength) {
        if (fieldLength >= this.issueTextSystemFieldMaxLength.getOrDefault(issueId, 0)) {
            this.issueTextSystemFieldMaxLength.put(issueId, fieldLength);
        }
    }

    public void addComment(ExternalComment comment) {
        this.storeMaximumTextFieldLengthInIssue(comment.getIssueId(), StringUtils.length((String)comment.getBody()));
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public void setUnassignedIssuesAllowed(boolean unassignedIssuesAllowed) {
        this.unassignedIssuesAllowed = unassignedIssuesAllowed;
    }

    public BackupOverview getBackupOverview() {
        BackupSystemInformationImpl backupSystemInformation = new BackupSystemInformationImpl(this.getBuildNumber(), this.getEdition(), this.getPluginVersions(), this.unassignedIssuesAllowed(), this.issueIdToKeyMap, this.entities, this.entityCount);
        return new BackupOverviewImpl(backupSystemInformation, this.getProjects());
    }

    private boolean unassignedIssuesAllowed() {
        return this.unassignedIssuesAllowed;
    }

    public void populateInformationFromElement(String elementName, Map attributes) throws ParseException {
        this.entities.add(elementName);
        ++this.entityCount;
        for (BackupOverviewPopulator overviewPopulator : this.overviewPopulators) {
            overviewPopulator.populate(this, elementName, attributes);
        }
    }

    public void addExternalCustomField(ExternalCustomField externalCustomField) {
        this.customFields.add(externalCustomField);
    }

    public void addConfigurationContext(BackupOverviewBuilder.ConfigurationContext configuration) {
        this.configurationContexts.put((Object)configuration.getCustomFieldId(), (Object)configuration);
    }

    public void addFieldConfigSchemeIssueType(BackupOverviewBuilder.FieldConfigSchemeIssueType fieldConfigSchemeIssueType) {
        this.fieldConfigSchemeIssueTypes.put((Object)fieldConfigSchemeIssueType.getFieldConfigScheme(), (Object)fieldConfigSchemeIssueType);
    }

    protected void registerOverviewPopulators() {
        this.registerOverviewPopulator(new ProjectPopulator());
        this.registerOverviewPopulator(new ProjectComponentPopulator());
        this.registerOverviewPopulator(new ProjectVersionPopulator());
        this.registerOverviewPopulator(new CustomFieldPopulator());
        this.registerOverviewPopulator(new PluginVersionPopulator());
        this.registerOverviewPopulator(new IssueIdPopulator());
        this.registerOverviewPopulator(new SystemInfoPopulator());
        this.registerOverviewPopulator(new CommentPopulator());
    }

    protected void registerOverviewPopulator(BackupOverviewPopulator populator) {
        this.overviewPopulators.add(populator);
    }

    List<? extends BackupProject> getProjects() {
        ArrayList<BackupProjectImpl> fullProjects = new ArrayList<BackupProjectImpl>(this.projects.size());
        for (ExternalProject project : this.projects) {
            List<Long> issueIds;
            List<ExternalComponent> components;
            List<ExternalVersion> versions = this.versions.get((Object)project.getId());
            if (versions == null) {
                versions = Collections.emptyList();
            }
            if ((components = this.components.get((Object)project.getId())) == null) {
                components = Collections.emptyList();
            }
            if ((issueIds = this.issueIds.get((Object)project.getId())) == null) {
                issueIds = Collections.emptyList();
            }
            List<ExternalCustomFieldConfiguration> customFieldConfigs = this.getCustomFieldConfigurations(project.getId());
            Map<String, Collection<Object>> projectAdditionalData = this.getProjectAdditionalData(project.getId());
            int maxTextLengthInProject = this.getMaxTextLengthInProject(issueIds);
            fullProjects.add(new BackupProjectImpl(project, versions, components, customFieldConfigs, issueIds, maxTextLengthInProject, projectAdditionalData));
        }
        return fullProjects;
    }

    private int getMaxTextLengthInProject(List<Long> issueIds) {
        return issueIds.stream().map(String::valueOf).mapToInt(id -> this.issueTextSystemFieldMaxLength.getOrDefault(id, 0)).max().orElseGet(() -> 0);
    }

    private Map<String, Collection<Object>> getProjectAdditionalData(String projectId) {
        HashMap<String, Collection<Object>> projectAdditionalData = new HashMap<String, Collection<Object>>();
        for (Map.Entry<String, ListMultimap<String, Object>> dataEntry : this.additionalData.entrySet()) {
            ListMultimap<String, Object> keyData = dataEntry.getValue();
            List data = keyData.get((Object)projectId);
            if (data == null) continue;
            projectAdditionalData.put(dataEntry.getKey(), data);
        }
        return projectAdditionalData;
    }

    List<ExternalCustomFieldConfiguration> getCustomFieldConfigurations(String projectId) {
        ArrayList<ExternalCustomFieldConfiguration> externalCustomFieldConfigurationList = new ArrayList<ExternalCustomFieldConfiguration>(this.customFields.size());
        for (ExternalCustomField customField : this.customFields) {
            BackupOverviewBuilder.ConfigurationContext configurationContext = this.getRelevantConfiguratonContext(projectId, customField.getId());
            if (configurationContext == null) continue;
            List fieldConfigIssueTypes = this.fieldConfigSchemeIssueTypes.get((Object)configurationContext.getConfigSchemeId());
            if (fieldConfigIssueTypes != null) {
                List<String> issuesTypes = this.getIssueTypesList(fieldConfigIssueTypes);
                externalCustomFieldConfigurationList.add(new ExternalCustomFieldConfiguration(issuesTypes, configurationContext.getProjectId(), customField, configurationContext.getConfigSchemeId()));
                continue;
            }
            log.warn(String.format("Skipped Custom Field %s (%s), because of missing config scheme, id: %s", customField.getName(), customField.getId(), configurationContext.getConfigSchemeId()));
        }
        return externalCustomFieldConfigurationList;
    }

    private BackupOverviewBuilder.ConfigurationContext getRelevantConfiguratonContext(String projectId, String customFieldId) {
        List configContexts = this.configurationContexts.get((Object)customFieldId);
        if (configContexts == null) {
            return null;
        }
        BackupOverviewBuilder.ConfigurationContext globalContext = null;
        for (BackupOverviewBuilder.ConfigurationContext configContext : configContexts) {
            if (configContext.getProjectId() == null) {
                globalContext = configContext;
                continue;
            }
            if (!configContext.getProjectId().equals(projectId)) continue;
            return configContext;
        }
        return globalContext;
    }

    private List<String> getIssueTypesList(List<BackupOverviewBuilder.FieldConfigSchemeIssueType> fieldConfigIssueTypes) {
        ArrayList<String> ids = new ArrayList<String>(fieldConfigIssueTypes.size());
        for (BackupOverviewBuilder.FieldConfigSchemeIssueType fieldConfigIssueType : fieldConfigIssueTypes) {
            String type = fieldConfigIssueType.getIssueType();
            if (type == null) {
                return null;
            }
            ids.add(type);
        }
        return ids;
    }

    List<PluginVersion> getPluginVersions() {
        return this.pluginVersions;
    }

    String getBuildNumber() {
        return this.buildNumber;
    }

    String getEdition() {
        return this.edition;
    }

    public void addAdditionalData(String key, String projectId, Object data) {
        ArrayListMultimap additionalDataForKey = this.additionalData.get(key);
        if (additionalDataForKey == null) {
            additionalDataForKey = ArrayListMultimap.create();
            this.additionalData.put(key, (ListMultimap<String, Object>)additionalDataForKey);
        }
        additionalDataForKey.put((Object)projectId, data);
    }
}

