/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import java.util.Map;

public class IssueComponentMapperHandler
implements ImportOfBizEntityHandler {
    private NodeAssociationParser nodeAssocationParser;
    private final SimpleProjectImportIdMapper componentMapper;
    private final BackupProject backupProject;

    public IssueComponentMapperHandler(BackupProject backupProject, SimpleProjectImportIdMapper componentMapper) {
        this.backupProject = backupProject;
        this.componentMapper = componentMapper;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        ExternalNodeAssociation nodeAssociation;
        if ("NodeAssociation".equals(entityName) && "IssueComponent".equals((nodeAssociation = this.getNodeAssociationParser().parse(attributes)).getAssociationType()) && this.backupProject.containsIssue(nodeAssociation.getSourceNodeId())) {
            this.componentMapper.flagValueAsRequired(nodeAssociation.getSinkNodeId());
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueComponentMapperHandler that = (IssueComponentMapperHandler)o;
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.componentMapper != null ? !this.componentMapper.equals(that.componentMapper) : that.componentMapper != null) {
            return false;
        }
        return !(this.nodeAssocationParser != null ? !this.nodeAssocationParser.equals(that.nodeAssocationParser) : that.nodeAssocationParser != null);
    }

    public int hashCode() {
        int result = this.nodeAssocationParser != null ? this.nodeAssocationParser.hashCode() : 0;
        result = 31 * result + (this.componentMapper != null ? this.componentMapper.hashCode() : 0);
        result = 31 * result + (this.backupProject != null ? this.backupProject.hashCode() : 0);
        return result;
    }
}

