/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import com.atlassian.jira.imports.project.transformer.VersionTransformer;
import com.atlassian.jira.imports.project.transformer.VersionTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(VersionPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private NodeAssociationParser nodeAssocationParser;
    private VersionTransformer versionTransformer;

    public VersionPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        ExternalNodeAssociation tranformedExternalVersion;
        ExternalNodeAssociation externalVersion;
        if ("NodeAssociation".equals(entityName) && (externalVersion = this.getNodeAssociationParser().parse(attributes)) != null && ("IssueVersion".equals(externalVersion.getAssociationType()) || "IssueFixVersion".equals(externalVersion.getAssociationType())) && (tranformedExternalVersion = this.getVersionTransformer().transform(this.projectImportMapper, externalVersion)) != null) {
            if (tranformedExternalVersion.getSourceNodeId() != null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!VersionPersisterHandler.this.projectImportPersister.createAssociation(tranformedExternalVersion)) {
                            String issueKey = VersionPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalVersion.getSourceNodeId());
                            String versionName = VersionPersisterHandler.this.projectImportMapper.getVersionMapper().getDisplayName(externalVersion.getSinkNodeId());
                            if ("IssueVersion".equals(externalVersion.getAssociationType())) {
                                VersionPersisterHandler.this.projectImportResults.addError(VersionPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.version.affects.error", versionName, issueKey));
                            }
                            if ("IssueFixVersion".equals(externalVersion.getAssociationType())) {
                                VersionPersisterHandler.this.projectImportResults.addError(VersionPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.version.fixfor.error", versionName, issueKey));
                            }
                        }
                    }
                });
            } else {
                String issueKey = this.backupSystemInformation.getIssueKeyForId(externalVersion.getSourceNodeId());
                String versionName = this.projectImportMapper.getVersionMapper().getDisplayName(externalVersion.getSinkNodeId());
                if ("IssueVersion".equals(externalVersion.getAssociationType())) {
                    log.warn("Not saving affects version '" + versionName + "' it appears that the issue '" + issueKey + "' was not created as part of the import.");
                }
                if ("IssueFixVersion".equals(externalVersion.getAssociationType())) {
                    log.warn("Not saving fix version '" + versionName + "' it appears that the issue '" + issueKey + "' was not created as part of the import.");
                }
            }
        }
    }

    VersionTransformer getVersionTransformer() {
        if (this.versionTransformer == null) {
            this.versionTransformer = new VersionTransformerImpl();
        }
        return this.versionTransformer;
    }

    NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

