/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.xml;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.imports.xml.BackupXmlParser;
import com.atlassian.jira.util.XmlReader;
import com.atlassian.jira.util.xml.JiraFileInputStream;
import com.atlassian.jira.util.xml.SecureXmlEntityResolver;
import com.atlassian.jira.util.xml.XMLEscapingReader;
import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultBackupXmlParser
implements BackupXmlParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultBackupXmlParser.class);
    private static final EntityResolver EMPTY_ENTITY_RESOLVER = new SecureXmlEntityResolver();
    private final ApplicationProperties applicationProperties;

    public DefaultBackupXmlParser(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void parseOfBizBackupXml(String fileName, DefaultHandler handler) throws IOException, SAXException {
        this.parseXml(fileName, handler, "entities.xml");
    }

    @Override
    public void parseAoBackupXml(String fileName, DefaultHandler handler) throws IOException, SAXException {
        this.parseXml(fileName, handler, "activeobjects.xml");
    }

    private void parseXml(String fileName, DefaultHandler handler, String entryName) throws IOException, SAXException {
        XmlParser xmlParser = new XmlParser(handler);
        try {
            this.parse(xmlParser, fileName, entryName);
        }
        catch (IOException | RuntimeException | SAXException e) {
            log.error("Unexpected import failure", (Throwable)e);
            throw e;
        }
    }

    private void parse(XmlParser xmlParser, String fileName, String zipEntryName) throws IOException, SAXException {
        JiraFileInputStream is = new JiraFileInputStream(new File(fileName), zipEntryName);
        try (CloseableInputSource inputSource = this.cleanXml() ? new CloseableInputSource(this.getFilteredReader(is)) : new CloseableInputSource(is);){
            xmlParser.parseXml(inputSource);
        }
    }

    private Reader getFilteredReader(InputStream is) throws IOException {
        XmlReader xmlReader = XmlReader.createReader(is);
        return new XMLEscapingReader(new InputStreamReader(xmlReader.getInputStream(), xmlReader.getEncoding()));
    }

    private boolean cleanXml() {
        return this.applicationProperties.getOption("jira.exportimport.cleanxml");
    }

    private class XmlParser {
        private final DefaultHandler handler;

        private XmlParser(DefaultHandler handler) {
            this.handler = handler;
        }

        public void parseXml(InputSource inputSource) throws IOException, SAXException {
            XMLReader reader = SecureXmlParserFactory.newXmlReader();
            reader.setEntityResolver(EMPTY_ENTITY_RESOLVER);
            if (log.isDebugEnabled()) {
                log.debug("Start parsing XML with SAX Parser");
            }
            reader.setContentHandler(this.handler);
            reader.parse(inputSource);
            if (log.isDebugEnabled()) {
                log.debug("XML successfully parsed");
            }
        }
    }

    private class CloseableInputSource
    extends InputSource
    implements Closeable {
        private final Closeable closeable;

        private CloseableInputSource(Reader reader) {
            super(reader);
            this.closeable = reader;
        }

        private CloseableInputSource(InputStream is) {
            super(is);
            this.closeable = is;
        }

        @Override
        public void close() throws IOException {
            this.closeable.close();
        }
    }
}

