/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.FutureResult;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingStrategy;
import com.atlassian.jira.index.MultiThreadedIndexingConfiguration;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.concurrent.BoundedExecutor;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;

public class MultiThreadedIndexingStrategy
implements IndexingStrategy {
    private final BoundedExecutor executor;
    private final IndexingStrategy strategy;

    public MultiThreadedIndexingStrategy(@Nonnull IndexingStrategy strategy, MultiThreadedIndexingConfiguration config, String threadPrefix) {
        this.strategy = (IndexingStrategy)Assertions.notNull((String)"strategy", (Object)strategy);
        this.executor = new BoundedExecutor(Executors.newFixedThreadPool(config.noOfThreads(), ThreadFactories.namedThreadFactory(threadPrefix)), config.maximumQueueSize());
    }

    public Index.Result get(final Supplier<Index.Result> input) {
        return new FutureResult(this.executor.submit(new Callable<Index.Result>(){

            @Override
            public Index.Result call() throws Exception {
                return (Index.Result)MultiThreadedIndexingStrategy.this.strategy.get(input);
            }
        }));
    }

    @Override
    public void close() {
        this.executor.shutdownAndWait();
    }
}

