/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexMetadata {
    private static final Logger log = LoggerFactory.getLogger(ReindexMetadata.class);
    private static final String METADATA_FILENAME = "reindex-metadata.properties";
    private static final String INDEX_START_TIME_KEY = "index.start.time";
    private final Properties properties = new Properties();

    public ReindexMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReindexMetadata(File indexDir) throws IOException {
        if (!indexDir.isDirectory() || !indexDir.canRead()) {
            throw new IOException(indexDir + " is not a readable directory");
        }
        File metadataFile = new File(indexDir, METADATA_FILENAME);
        if (metadataFile.exists()) {
            FileReader in = new FileReader(metadataFile);
            try {
                this.loadProperties(in);
            }
            finally {
                IOUtils.closeQuietly((Reader)in);
            }
        }
    }

    private void loadProperties(Reader in) throws IOException {
        this.properties.load(in);
    }

    @Nullable
    public Date getIndexStartTime() {
        Date startDate;
        String startTimeValue = this.properties.getProperty(INDEX_START_TIME_KEY);
        if (startTimeValue != null && !startTimeValue.isEmpty()) {
            try {
                startDate = new Date(Long.parseLong(startTimeValue));
            }
            catch (NumberFormatException e) {
                log.error("Invalid value for key index.start.time in index snapshot metadata", (Throwable)e);
                startDate = null;
            }
        } else {
            startDate = null;
        }
        return startDate;
    }

    public void setIndexStartTime(long indexStartTime) {
        this.properties.setProperty(INDEX_START_TIME_KEY, Long.toString(indexStartTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTo(File targetDir) throws IOException {
        File metadataFile = new File(targetDir, METADATA_FILENAME);
        FileWriter writer = new FileWriter(metadataFile);
        try {
            this.properties.store(writer, null);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

