/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;

class MemoryExternalGauges {
    MemoryExternalGauges() {
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.memory.heap.committed", (ExternalValue)new MemoryMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getHeapMemoryUsage().getCommitted();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.memory.heap.used", (ExternalValue)new MemoryMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getHeapMemoryUsage().getUsed();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.memory.nonheap.committed", (ExternalValue)new MemoryMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getNonHeapMemoryUsage().getCommitted();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.memory.nonheap.used", (ExternalValue)new MemoryMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getNonHeapMemoryUsage().getUsed();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.system.up.time", new ExternalValue(){

            public long getValue() {
                return ManagementFactory.getRuntimeMXBean().getUptime();
            }
        }));
    }

    private static abstract class MemoryMXExternalValue
    implements ExternalValue {
        private MemoryMXExternalValue() {
        }

        MemoryMXBean getMxBean() {
            return ManagementFactory.getMemoryMXBean();
        }
    }
}

