/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentsMonitorLocator;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.issue.DefaultTemporaryWebAttachmentsMonitor;
import com.atlassian.jira.web.action.issue.TemporaryWebAttachmentsMonitor;
import com.google.common.base.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DefaultTemporaryWebAttachmentsMonitorLocator
implements TemporaryWebAttachmentsMonitorLocator {
    private final StreamAttachmentStore attachmentStore;

    public DefaultTemporaryWebAttachmentsMonitorLocator(StreamAttachmentStore attachmentStore) {
        this.attachmentStore = attachmentStore;
    }

    private Option<TemporaryWebAttachmentsMonitor> getMonitorFromSession(Option<HttpSession> sessionOption) {
        return sessionOption.flatMap(session -> Option.option((Object)((TemporaryWebAttachmentsMonitor)session.getAttribute("jira.issue.temp.web_attachments"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemporaryWebAttachmentsMonitor createNewMonitor(HttpSession session) {
        DefaultTemporaryWebAttachmentsMonitor monitor = new DefaultTemporaryWebAttachmentsMonitor(this.attachmentStore);
        HttpSession httpSession = session;
        synchronized (httpSession) {
            Object oldMonitor = session.getAttribute("jira.issue.temp.web_attachments");
            if (oldMonitor == null) {
                session.setAttribute("jira.issue.temp.web_attachments", (Object)monitor);
                return monitor;
            }
            return (TemporaryWebAttachmentsMonitor)oldMonitor;
        }
    }

    private Option<HttpSession> getCurrentSession() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        return request == null ? Option.none() : Option.some((Object)request.getSession());
    }

    @Override
    public Option<TemporaryWebAttachmentsMonitor> get() {
        Option<HttpSession> currentSession = this.getCurrentSession();
        return this.getMonitorFromSession(currentSession);
    }

    @Override
    public TemporaryWebAttachmentsMonitor getOrCreate() {
        Option<HttpSession> sessionOption = this.getCurrentSession();
        final HttpSession session = (HttpSession)sessionOption.getOrThrow(() -> {
            throw new IllegalStateException("Session doesn't exists, this method cannot work outside HTTP session!");
        });
        return (TemporaryWebAttachmentsMonitor)this.getMonitorFromSession(sessionOption).getOrElse((Supplier)new Supplier<TemporaryWebAttachmentsMonitor>(){

            public TemporaryWebAttachmentsMonitor get() {
                return DefaultTemporaryWebAttachmentsMonitorLocator.this.createNewMonitor(session);
            }
        });
    }
}

