/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentDirectoryAccessor;
import com.atlassian.jira.issue.attachment.AttachmentFileGetData;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentMoveException;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.FileAttachments;
import com.atlassian.jira.issue.attachment.FileSystemAttachmentStore;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.store.LocalTemporaryFileStore;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ExecutorServiceWrapper;
import com.atlassian.util.concurrent.Functions;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class DefaultFileSystemAttachmentStore
implements FileSystemAttachmentStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileSystemAttachmentStore.class);
    private final AttachmentDirectoryAccessor directoryAccessor;
    private final ExecutorServiceWrapper managedExecutor;
    private final LocalTemporaryFileStore localTemporaryFileStore;
    private final EventPublisher eventPublisher;

    public DefaultFileSystemAttachmentStore(AttachmentDirectoryAccessor directoryAccessor, LocalTemporaryFileStore localTemporaryFileStore, ExecutorServiceWrapper managedExecutor, EventPublisher eventPublisher) {
        this.directoryAccessor = directoryAccessor;
        this.localTemporaryFileStore = localTemporaryFileStore;
        this.managedExecutor = managedExecutor;
        this.eventPublisher = eventPublisher;
    }

    public File getAttachmentFile(AttachmentKey attachmentKey) throws DataAccessException {
        return FileAttachments.getAttachmentFileHolder((AttachmentKey)attachmentKey, (File)this.directoryAccessor.getAttachmentRootPath());
    }

    public File getAttachmentFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDir) {
        return FileAttachments.getAttachmentFileHolder((AttachmentStore.AttachmentAdapter)attachment, (File)attachmentDir);
    }

    @Nonnull
    public Promise<StoreAttachmentResult> putAttachment(@Nonnull StoreAttachmentBean storeAttachmentBean) {
        InputStream dataStream = storeAttachmentBean.getStream();
        AttachmentKey attachmentKey = storeAttachmentBean.getAttachmentKey();
        return this.putAttachment(dataStream, storeAttachmentBean.getSize(), attachmentKey);
    }

    private Promise<StoreAttachmentResult> putAttachment(InputStream inputStream, Long size, final AttachmentKey attachmentKey) {
        return this.putTemporaryAttachment(inputStream, size).flatMap(Functions.toGoogleFunction((com.atlassian.util.concurrent.Function)new com.atlassian.util.concurrent.Function<TemporaryAttachmentId, Promise<? extends StoreAttachmentResult>>(){

            public Promise<? extends StoreAttachmentResult> get(TemporaryAttachmentId temporaryAttachmentId) {
                return DefaultFileSystemAttachmentStore.this.moveTemporaryToAttachment(temporaryAttachmentId, attachmentKey).flatMap(Functions.toGoogleFunction((com.atlassian.util.concurrent.Function)new com.atlassian.util.concurrent.Function<Unit, Promise<? extends StoreAttachmentResult>>(){

                    public Promise<? extends StoreAttachmentResult> get(Unit input) {
                        return Promises.promise((Object)StoreAttachmentResult.created());
                    }
                }));
            }
        }));
    }

    private File getAttachmentFileHolder(AttachmentKey attachmentKey) {
        return FileAttachments.getAttachmentFileHolder((AttachmentKey)attachmentKey, (File)this.directoryAccessor.getAttachmentRootPath());
    }

    public <A> Promise<A> getAttachment(AttachmentKey attachmentKey, final com.atlassian.util.concurrent.Function<InputStream, A> inputStreamProcessor) {
        return this.getAttachmentData(attachmentKey, new com.atlassian.util.concurrent.Function<AttachmentGetData, A>(){

            public A get(AttachmentGetData attachmentGetData) {
                return inputStreamProcessor.get((Object)attachmentGetData.getInputStream());
            }
        });
    }

    public <A> Promise<A> getAttachmentData(AttachmentKey attachmentKey, final com.atlassian.util.concurrent.Function<AttachmentGetData, A> attachmentGetDataProcessor) {
        File attachmentFile;
        try {
            attachmentFile = this.getAttachmentFile(attachmentKey);
        }
        catch (DataAccessException e) {
            return Promises.rejected((Throwable)new AttachmentReadException((Throwable)e));
        }
        if (!attachmentFile.exists() || !attachmentFile.isFile()) {
            return Promises.rejected((Throwable)new NoAttachmentDataException("Attachment does not exist in filesystem " + attachmentFile));
        }
        return this.managedExecutor.submit(new Callable<A>(){

            @Override
            public A call() {
                try (AttachmentFileGetData attachmentGetData = new AttachmentFileGetData(attachmentFile);){
                    Object object = attachmentGetDataProcessor.get((Object)attachmentGetData);
                    return object;
                }
            }
        });
    }

    public Promise<Boolean> exists(AttachmentKey attachmentKey) {
        File attachmentFile = this.getAttachmentFile(attachmentKey);
        return Promises.promise((Object)(attachmentFile.exists() && attachmentFile.isFile() ? 1 : 0));
    }

    public Promise<Unit> deleteAttachment(AttachmentKey attachmentKey) {
        try {
            File attachmentFile = this.getAttachmentFile(attachmentKey);
            if (attachmentFile.exists()) {
                if (!attachmentFile.delete()) {
                    log.warn("Failed to delete attachmentFile: " + attachmentFile.getAbsolutePath());
                }
                this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.ATTACHMENT, attachmentFile));
            } else {
                log.warn("Trying to delete non-existent attachment: [" + attachmentFile.getAbsolutePath() + "] ..ignoring");
            }
        }
        catch (DataAccessException e) {
            Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
        }
        return Promises.promise((Object)Unit.VALUE);
    }

    public Promise<Unit> deleteAttachmentContainerForIssue(Issue issue) {
        Preconditions.checkNotNull((Object)issue);
        File attachmentDir = this.directoryAccessor.getAttachmentDirectory(issue);
        try {
            FileUtils.deleteDirectory((File)attachmentDir);
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.ATTACHMENT, attachmentDir));
            return Promises.promise((Object)Unit.VALUE);
        }
        catch (IOException e) {
            return Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
        }
    }

    public Promise<Unit> moveAttachment(AttachmentKey oldAttachmentKey, AttachmentKey newAttachmentKey) {
        File oldAttachmentFile = this.getAttachmentFile(oldAttachmentKey);
        File newAttachmentFile = this.getAttachmentFile(newAttachmentKey);
        return this.moveFile(oldAttachmentFile, newAttachmentFile, false);
    }

    @Nonnull
    public Option<ErrorCollection> errors() {
        return this.directoryAccessor.errors();
    }

    public Promise<Unit> copyAttachment(AttachmentKey sourceAttachmentKey, final AttachmentKey newAttachmentKey) {
        return this.getAttachment(sourceAttachmentKey, new com.atlassian.util.concurrent.Function<InputStream, TemporaryAttachmentId>(){

            public TemporaryAttachmentId get(InputStream input) {
                return DefaultFileSystemAttachmentStore.this.localTemporaryFileStore.createTemporaryFile(input);
            }
        }).flatMap((Function)new Function<TemporaryAttachmentId, Promise<Unit>>(){

            public Promise<Unit> apply(TemporaryAttachmentId temporaryFile) {
                return DefaultFileSystemAttachmentStore.this.moveTemporaryToAttachment(temporaryFile, newAttachmentKey);
            }
        });
    }

    public Promise<TemporaryAttachmentId> putTemporaryAttachment(final InputStream inputStream, final long size) {
        return this.managedExecutor.submit((Callable)new Callable<TemporaryAttachmentId>(){

            @Override
            public TemporaryAttachmentId call() throws Exception {
                return DefaultFileSystemAttachmentStore.this.localTemporaryFileStore.createTemporaryFile(inputStream, size);
            }
        });
    }

    public Promise<Unit> moveTemporaryToAttachment(TemporaryAttachmentId temporaryAttachmentId, AttachmentKey destinationKey) {
        Either<Exception, File> tempFileEitherException = this.localTemporaryFileStore.getTemporaryAttachmentFile(temporaryAttachmentId);
        if (tempFileEitherException.isLeft()) {
            return Promises.rejected((Throwable)((Throwable)tempFileEitherException.left().get()));
        }
        File tempFile = (File)tempFileEitherException.right().get();
        File destinationFile = this.getAttachmentFileHolder(destinationKey);
        return this.moveFile(tempFile, destinationFile, true);
    }

    private Promise<Unit> moveFile(File sourceFile, File destinationFile, boolean isTemporary) {
        File parentFile = destinationFile.getParentFile();
        if (!this.ensureDirectoryExists(parentFile)) {
            return Promises.rejected((Throwable)new AttachmentMoveException("Unable to create target directory " + parentFile.getAbsolutePath()));
        }
        return this.renameOrCopyAndDeleteFile(sourceFile, destinationFile, isTemporary);
    }

    private boolean ensureDirectoryExists(File directory) {
        return directory.mkdirs() || directory.exists();
    }

    private Promise<Unit> renameOrCopyAndDeleteFile(File sourceFile, File destinationFile, boolean isTemporary) {
        if (!sourceFile.exists()) {
            return Promises.rejected((Throwable)new NoAttachmentDataException("Source file does not exist " + sourceFile.getAbsolutePath()));
        }
        try {
            Files.move((File)sourceFile, (File)destinationFile);
            if (!isTemporary) {
                this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.ATTACHMENT, sourceFile));
            }
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.ATTACHMENT, destinationFile));
            return Promises.promise((Object)Unit.VALUE);
        }
        catch (IOException e) {
            return Promises.rejected((Throwable)new AttachmentMoveException("Unable to create target file " + destinationFile.getAbsolutePath()));
        }
    }

    public Promise<Unit> deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        return this.localTemporaryFileStore.deleteTemporaryAttachment(temporaryAttachmentId);
    }
}

