/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomFieldParser;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.ProjectImportLabelFieldParser;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.LabelsCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelsCFType
extends AbstractCustomFieldType<Set<Label>, Label>
implements SortableCustomField<Set<Label>>,
ProjectImportableCustomFieldParser,
ProjectImportableCustomField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    private static final Logger log = LoggerFactory.getLogger(LabelsCFType.class);
    private final JiraAuthenticationContext authContext;
    private final IssueManager issueManager;
    private final GenericConfigManager genericConfigManager;
    private final LabelUtil labelUtil;
    private final LabelManager labelManager;
    private final ProjectImportableCustomFieldParser projectImportLabelFieldParser;
    private final JiraBaseUrls jiraBaseUrls;

    public LabelsCFType(JiraAuthenticationContext authenticationContext, IssueManager issueManager, GenericConfigManager genericConfigManager, LabelUtil labelUtil, LabelManager labelManager, ProjectImportLabelFieldParser projectImportableCustomFieldParser, JiraBaseUrls jiraBaseUrls) {
        this.authContext = authenticationContext;
        this.issueManager = issueManager;
        this.genericConfigManager = genericConfigManager;
        this.labelUtil = labelUtil;
        this.labelManager = labelManager;
        this.projectImportLabelFieldParser = projectImportableCustomFieldParser;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map velocityParameters = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue == null || issue.getId() == null) {
            velocityParameters.put("canEdit", Boolean.FALSE);
        } else {
            MutableIssue issueFromDb = this.issueManager.getIssueObject(issue.getId());
            velocityParameters.put("canEdit", this.issueManager.isEditable((Issue)issueFromDb, this.authContext.getUser()));
            velocityParameters.put("labels", this.getValueFromIssue(field, issue));
        }
        velocityParameters.put("fieldId", field.getId());
        velocityParameters.put("i18n", this.authContext.getI18nHelper());
        velocityParameters.put("field", field);
        velocityParameters.put("labelUtil", this.labelUtil);
        velocityParameters.put("issue", issue);
        velocityParameters.put("labelParser", new LabelParser());
        return velocityParameters;
    }

    public Set<Label> getValueFromIssue(CustomField field, Issue issue) {
        Set labels = this.labelManager.getLabels(issue.getId(), field.getIdAsLong());
        if (labels.isEmpty()) {
            return null;
        }
        return labels;
    }

    public Set<Label> getDefaultValue(FieldConfig fieldConfig) {
        Object databaseValue = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (databaseValue != null) {
            try {
                String labelsString = (String)databaseValue;
                return this.convertStringsToLabels(Collections.singleton(labelsString));
            }
            catch (FieldValidationException e) {
                log.error("Invalid default value encountered", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void setDefaultValue(FieldConfig fieldConfig, Set<Label> value) {
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), (Object)this.convertLabelsToString(value));
    }

    public String getChangelogValue(CustomField field, Set<Label> value) {
        if (value == null) {
            return "";
        }
        return this.convertLabelsToString(value);
    }

    public String getStringFromSingularObject(Label singularObject) {
        if (singularObject == null) {
            return null;
        }
        return singularObject.getLabel();
    }

    public Label getSingularObjectFromString(String string) throws FieldValidationException {
        if (string == null) {
            return null;
        }
        int labelLength = StringUtils.length((String)string.trim());
        if (LabelParser.isValidLabelName((String)string) && labelLength <= 255) {
            return new Label(null, null, string);
        }
        if (labelLength > 255) {
            throw new FieldValidationException(this.authContext.getI18nHelper().getText("label.service.error.label.toolong", string));
        }
        throw new FieldValidationException(this.authContext.getI18nHelper().getText("label.service.error.label.invalid", string));
    }

    public Set<Long> remove(CustomField field) {
        return this.labelManager.removeLabelsForCustomField(field.getIdAsLong());
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        try {
            this.getValueFromCustomFieldParams(relevantParams);
        }
        catch (FieldValidationException e) {
            errorCollectionToAddTo.addError(config.getCustomField().getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public void createValue(CustomField field, Issue issue, @Nonnull Set<Label> value) {
        this.setLabels(field, issue, value);
    }

    public void updateValue(CustomField field, Issue issue, Set<Label> value) {
        this.setLabels(field, issue, value);
    }

    private void setLabels(CustomField field, Issue issue, Set<Label> value) {
        LinkedHashSet<String> labelStrings = new LinkedHashSet<String>();
        if (value != null) {
            for (Label label : value) {
                labelStrings.add(label.getLabel());
            }
        }
        this.labelManager.setLabels(this.authContext.getUser(), issue.getId(), field.getIdAsLong(), labelStrings, false, false);
    }

    public Set<Label> getValueFromCustomFieldParams(CustomFieldParams customFieldParams) throws FieldValidationException {
        if (customFieldParams == null || customFieldParams.isEmpty()) {
            return null;
        }
        Collection normalParams = customFieldParams.getValuesForKey(null);
        if (normalParams == null || normalParams.isEmpty()) {
            return null;
        }
        return this.convertStringsToLabels(normalParams);
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection valuesForNullKey = parameters.getValuesForNullKey();
        if (valuesForNullKey != null) {
            StringBuilder ret = new StringBuilder();
            for (String value : valuesForNullKey) {
                ret.append(value).append(" ");
            }
            return ret.toString().trim();
        }
        return null;
    }

    public int compare(@Nonnull Set<Label> customFieldObjectValue1, @Nonnull Set<Label> customFieldObjectValue2, FieldConfig fieldConfig) {
        String stringValue1 = this.convertLabelsToString(customFieldObjectValue1);
        String stringValue2 = this.convertLabelsToString(customFieldObjectValue2);
        if (stringValue1 == null && stringValue2 == null) {
            return 0;
        }
        if (stringValue1 == null) {
            return 1;
        }
        if (stringValue2 == null) {
            return -1;
        }
        return stringValue1.compareTo(stringValue2);
    }

    private String convertLabelsToString(Set<Label> newLabels) {
        if (newLabels == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (Label newLabel : newLabels) {
            ret.append(newLabel).append(" ");
        }
        return ret.toString().trim();
    }

    private Set<Label> convertStringsToLabels(Collection<String> labelStrings) {
        LinkedHashSet<Label> ret = new LinkedHashSet<Label>();
        for (String labelString : labelStrings) {
            if (labelString.length() > 255) {
                throw new FieldValidationException(this.authContext.getI18nHelper().getText("label.service.error.label.toolong", labelString));
            }
            ret.addAll(LabelParser.buildFromString((String)labelString));
        }
        return ret;
    }

    public String getEntityName() {
        return this.projectImportLabelFieldParser.getEntityName();
    }

    public ExternalCustomFieldValue parse(Map attributes) throws ParseException {
        return this.projectImportLabelFieldParser.parse(attributes);
    }

    public EntityRepresentation getEntityRepresentation(ExternalCustomFieldValue customFieldValue) {
        return this.projectImportLabelFieldParser.getEntityRepresentation(customFieldValue);
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return new LabelCustomFieldImporter();
    }

    public boolean valuesEqual(Set<Label> oldLabels, Set<Label> newLabels) {
        if (oldLabels == newLabels) {
            return true;
        }
        if (oldLabels == null && newLabels.isEmpty()) {
            return true;
        }
        if (newLabels == null && oldLabels.isEmpty()) {
            return true;
        }
        return super.valuesEqual(oldLabels, newLabels);
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitLabels(this);
        }
        return super.accept(visitor);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        CustomField customField = (CustomField)fieldTypeInfoContext.getOderableField();
        if (fieldTypeInfoContext.getIssue() == null) {
            String autoCompleteUrl = String.format("%s/rest/api/1.0/labels/suggest?customFieldId=%s&query=", this.jiraBaseUrls.baseUrl(), customField.getIdAsLong());
            return new FieldTypeInfo(null, autoCompleteUrl);
        }
        String autoCompleteUrl = String.format("%s/rest/api/1.0/labels/" + fieldTypeInfoContext.getIssue().getId() + "/suggest?customFieldId=%s&query=", this.jiraBaseUrls.baseUrl(), customField.getIdAsLong());
        return new FieldTypeInfo(null, autoCompleteUrl);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.customArray((String)"string", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Object labels = this.getValueFromIssue(field, issue);
        if (labels == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        ImmutableList values = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)labels, (Function)new Function<Label, String>(){

            public String apply(Label from) {
                return from.getLabel();
            }
        }));
        return new FieldJsonRepresentation(new JsonData((Object)values));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new LabelsCustomFieldOperationsHandler(field, this.getI18nBean());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        Object defaultValue = field.getCustomFieldType().getDefaultValue(config);
        return defaultValue == null ? null : new JsonData(defaultValue);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitLabels(LabelsCFType var1);
    }

    static class LabelCustomFieldImporter
    implements ProjectCustomFieldImporter {
        LabelCustomFieldImporter() {
        }

        public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
            MessageSetImpl messageSet = new MessageSetImpl();
            String label = customFieldValue.getValue();
            if (!LabelParser.isValidLabelName((String)label)) {
                messageSet.addWarningMessage(i18n.getText("label.project.import.error", label));
                messageSet.addWarningMessageInEnglish("Dropping label '" + label + "' because it contains invalid characters.");
            }
            return messageSet;
        }

        public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
            String label = customFieldValue.getValue();
            if (LabelParser.isValidLabelName((String)label)) {
                return new ProjectCustomFieldImporter.MappedCustomFieldValue(label);
            }
            return new ProjectCustomFieldImporter.MappedCustomFieldValue(null);
        }
    }
}

