/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.bc.issue.properties.IssuePropertyHelper;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.io.InputStreamFunctionFactory;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentKeyMapper;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.store.strategy.move.IOUtilsWrapper;
import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntry;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveImpl;
import com.atlassian.jira.plugin.attachment.AttachmentProcessor;
import com.atlassian.jira.plugin.attachment.AttachmentProcessorModuleDescriptor;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttachmentIndexManager
implements AttachmentIndexManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAttachmentIndexManager.class);
    private static final String NO_INDEX = "[]";
    private final PluginAccessor pluginAccessor;
    private final StreamAttachmentStore attachmentStore;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final IssuePropertyHelper issuePropertyHelper;
    private final String entityDbName;
    private final IOUtilsWrapper fileFactory;
    private final InputStreamFunctionFactory inputStreamFunctionFactory;
    private final AttachmentKeyMapper attachmentKeyMapper;

    public DefaultAttachmentIndexManager(PluginAccessor pluginAccessor, StreamAttachmentStore attachmentStore, JsonEntityPropertyManager jsonEntityPropertyManager, IssuePropertyHelper entityPropertyHelper, IOUtilsWrapper fileFactory, InputStreamFunctionFactory inputStreamFunctionFactory, AttachmentKeyMapper attachmentKeyMapper) {
        this.pluginAccessor = pluginAccessor;
        this.attachmentStore = attachmentStore;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.issuePropertyHelper = entityPropertyHelper;
        this.fileFactory = fileFactory;
        this.inputStreamFunctionFactory = inputStreamFunctionFactory;
        this.attachmentKeyMapper = attachmentKeyMapper;
        this.entityDbName = entityPropertyHelper.getEntityPropertyType().getDbEntityName();
    }

    @Override
    public void processAttachmentAndCreateIndex(@Nonnull File file, @Nonnull Attachment attachment, @Nonnull Issue issue) {
        this.processAttachmentAndCreateIndex(file, attachment, issue, 0);
    }

    protected Option<AttachmentArchive> processAttachmentAndCreateIndex(@Nonnull File file, @Nonnull Attachment attachment, @Nonnull Issue issue, final int maxEntries) {
        Option<String> index = this.generateArchiveFileIndex(file, attachment);
        this.processAttachment((String)index.getOrElse((Object)NO_INDEX), attachment, issue);
        return index.map((Function)new Function<String, AttachmentArchive>(){

            public AttachmentArchive apply(String input) {
                return AttachmentArchiveImpl.fromJSONArrayQuiet(input, maxEntries);
            }
        });
    }

    private Option<String> generateArchiveFileIndex(@Nonnull File file, @Nonnull Attachment attachment) {
        Iterable<AttachmentProcessorModuleDescriptor> filteredProcessors = this.filterProcessors(attachment);
        if (Iterables.isEmpty(filteredProcessors)) {
            return Option.none();
        }
        AttachmentProcessorModuleDescriptor firstDescriptor = filteredProcessors.iterator().next();
        List<AttachmentArchiveEntry> entries = ((AttachmentProcessor)firstDescriptor.getModule()).processAttachment(file);
        Iterable<JSONObject> jsons = AttachmentArchiveImpl.serialize(entries);
        JSONArray array = new JSONArray((Collection)Lists.newArrayList((Iterable)Iterables.filter(jsons, (Predicate)new TotalLengthPredicate(32768L))));
        return Option.some((Object)array.toString());
    }

    private Iterable<AttachmentProcessorModuleDescriptor> filterProcessors(@Nonnull Attachment attachment) {
        final String fileExtension = FilenameUtils.getExtension((String)attachment.getFilename());
        return Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(AttachmentProcessorModuleDescriptor.class), (Predicate)new Predicate<AttachmentProcessorModuleDescriptor>(){

            public boolean apply(AttachmentProcessorModuleDescriptor attachmentProcessorModuleDescriptor) {
                return Iterables.any(attachmentProcessorModuleDescriptor.getFileExtensions(), (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String s) {
                        return fileExtension.equalsIgnoreCase(s);
                    }
                });
            }
        });
    }

    private void processAttachment(@Nonnull String index, @Nonnull Attachment attachment, @Nonnull Issue issue) {
        this.jsonEntityPropertyManager.put(null, this.entityDbName, issue.getId(), attachment.getId().toString(), index, this.issuePropertyHelper.createSetPropertyEventFunction(), true);
    }

    @Override
    public Option<AttachmentArchive> getAttachmentContents(final @Nonnull Attachment attachment, final @Nonnull Issue issue, final int maxEntries) {
        Option property = Option.option((Object)this.jsonEntityPropertyManager.get(this.entityDbName, issue.getId(), attachment.getId().toString()));
        return property.map((Function)new Function<EntityProperty, String>(){

            public String apply(EntityProperty property) {
                return property.getValue();
            }
        }).map((Function)new Function<String, AttachmentArchive>(){

            public AttachmentArchive apply(@Nullable String input) {
                return AttachmentArchiveImpl.fromJSONArrayQuiet(input, maxEntries);
            }
        }).orElse((Supplier)new Supplier<Option<AttachmentArchive>>(){

            public Option<AttachmentArchive> get() {
                return (Option)DefaultAttachmentIndexManager.this.fileFactory.processTemporaryFile("attachment-toc-", ".tmp", DefaultAttachmentIndexManager.this.generateIndex(attachment, issue, maxEntries));
            }
        });
    }

    private Function<File, Option<AttachmentArchive>> generateIndex(final Attachment attachment, final Issue issue, final int maxEntries) {
        return new Function<File, Option<AttachmentArchive>>(){

            public Option<AttachmentArchive> apply(final @Nullable File temporaryFile) {
                Preconditions.checkNotNull((Object)temporaryFile, (Object)"temporaryFile");
                final AttachmentKey attachmentKey = DefaultAttachmentIndexManager.this.attachmentKeyMapper.fromAttachment(attachment);
                com.atlassian.util.concurrent.Function<InputStream, Unit> saveStream = DefaultAttachmentIndexManager.this.inputStreamFunctionFactory.saveStream(temporaryFile);
                return (Option)DefaultAttachmentIndexManager.this.attachmentStore.getAttachment(attachmentKey, saveStream).fold((Function)new Function<Throwable, Option<AttachmentArchive>>(){

                    public Option<AttachmentArchive> apply(@Nullable Throwable throwable) {
                        log.debug(String.format("Failed to retrieve attachment with %s while generating attachment index.", attachmentKey), throwable);
                        return Option.none();
                    }
                }, (Function)new Function<Unit, Option<AttachmentArchive>>(){

                    public Option<AttachmentArchive> apply(@Nullable Unit unit) {
                        return DefaultAttachmentIndexManager.this.processAttachmentAndCreateIndex(temporaryFile, attachment, issue, maxEntries);
                    }
                }).claim();
            }
        };
    }

    @Override
    public void removeAttachmentIndex(@Nonnull Attachment attachment, @Nonnull Issue issue) {
        this.jsonEntityPropertyManager.delete(this.entityDbName, issue.getId(), attachment.getId().toString());
    }

    @Override
    public boolean isExpandable(Attachment attachment) {
        Iterable<AttachmentProcessorModuleDescriptor> processors = this.filterProcessors(attachment);
        return processors.iterator().hasNext();
    }

    @NotThreadSafe
    protected static class TotalLengthPredicate
    implements Predicate<JSONObject> {
        private static final int ADDITIONAL_CHARS_NEEDED = 6;
        private static final int ADDITIONAL_CHARS_PER_ENTRY = 2;
        private final long maxLength;
        private long currentLength;

        protected TotalLengthPredicate(long maxLength) {
            this.maxLength = maxLength;
            this.currentLength = 6L;
        }

        public boolean apply(JSONObject json) {
            long jsonLength = json.toString().length();
            if (this.currentLength + jsonLength + 2L < this.maxLength) {
                this.currentLength += jsonLength + 2L;
                return true;
            }
            return false;
        }
    }
}

