/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestEntity;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.ofbiz.DatabaseIterable;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.ofbiz.PagedDatabaseIterable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.IndexableSharedEntity;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizSearchRequestStore
implements SearchRequestStore {
    static final SharedEntity.TypeDescriptor<SearchRequest> ENTITY_TYPE = SearchRequest.ENTITY_TYPE;
    private static final Logger log = LoggerFactory.getLogger(OfBizSearchRequestStore.class);
    private final JqlQueryParser jqlQueryParser;
    private final SearchService searchService;
    private final UserManager userManager;
    private final OfBizDelegator delegator;
    private final Resolver<GenericValue, SearchRequest> searchRequestResolver = new Resolver<GenericValue, SearchRequest>(){

        public SearchRequest get(GenericValue input) {
            return OfBizSearchRequestStore.this.convertGVToRequest(input);
        }
    };
    private final Resolver<GenericValue, IndexableSharedEntity<SearchRequest>> indexableSharedEntityResolver = new Resolver<GenericValue, IndexableSharedEntity<SearchRequest>>(){

        public IndexableSharedEntity<SearchRequest> get(GenericValue input) {
            return OfBizSearchRequestStore.this.convertGVToIndexableSharedEntity(input);
        }
    };

    public OfBizSearchRequestStore(OfBizDelegator delegator, JqlQueryParser jqlQueryParser, SearchService searchService, UserManager userManager) {
        this.jqlQueryParser = jqlQueryParser;
        this.searchService = searchService;
        this.userManager = userManager;
        Assertions.notNull((String)"delegator", (Object)delegator);
        this.delegator = delegator;
    }

    @Override
    public EnclosedIterable<SearchRequest> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        if (!descriptor.getIds().isEmpty()) {
            Resolver<SearchRequest, Long> keyResolver = descriptor.preserveOrder() ? new Resolver<SearchRequest, Long>(){

                public Long get(SearchRequest input) {
                    return input.getId();
                }
            } : null;
            return new PagedDatabaseIterable<SearchRequest, Long>(descriptor.getIds(), (Resolver)keyResolver){

                @Override
                protected OfBizListIterator createListIterator(List<Long> ids) {
                    return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, (EntityCondition)new EntityExpr("id", EntityOperator.IN, ids));
                }

                @Override
                protected Resolver<GenericValue, SearchRequest> getResolver() {
                    return OfBizSearchRequestStore.this.searchRequestResolver;
                }
            };
        }
        return CollectionEnclosedIterable.from(Collections.emptyList());
    }

    @Override
    public void visitAll(Visitor<SearchRequestEntity> visitor) {
        Select.from(Entity.SEARCH_REQUEST).runWith(this.delegator).visitWith(visitor);
    }

    @Override
    public EnclosedIterable<SearchRequest> getAll() {
        try {
            return new DatabaseIterable<SearchRequest>(new Long(this.delegator.getCount(Table.NAME)).intValue(), this.searchRequestResolver){

                @Override
                protected OfBizListIterator createListIterator() {
                    return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, null);
                }
            };
        }
        catch (DataAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnclosedIterable<IndexableSharedEntity<SearchRequest>> getAllIndexableSharedEntities() {
        try {
            return new DatabaseIterable<IndexableSharedEntity<SearchRequest>>(new Long(this.delegator.getCount(Table.NAME)).intValue(), this.indexableSharedEntityResolver){

                @Override
                protected OfBizListIterator createListIterator() {
                    return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, null);
                }
            };
        }
        catch (DataAccessException e) {
            throw new RuntimeException(e);
        }
    }

    int getSearchRequestCountForProject(Long projectId) {
        EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)"project", (Object)projectId), EntityOperator.AND);
        GenericValue countGV = EntityUtil.getOnly((List)this.delegator.findByCondition(Table.COUNT, (EntityCondition)condition, (Collection)EasyList.build((Object)"count"), Collections.EMPTY_LIST));
        return countGV.getLong("count").intValue();
    }

    @Override
    public Collection<SearchRequest> getAllOwnedSearchRequests(ApplicationUser author) {
        if (author == null) {
            return Collections.emptyList();
        }
        return this.getAllOwnedSearchRequests(author.getKey());
    }

    @Override
    public Collection<SearchRequest> getAllOwnedSearchRequests(String userKey) {
        return CollectionUtil.transform(this.getSearchRequestGVsOwnedBy(userKey).iterator(), this.searchRequestResolver);
    }

    @Override
    public SearchRequest getRequestByAuthorAndName(ApplicationUser author, String name) {
        if (author == null) {
            return null;
        }
        List genericValues = this.delegator.findByAnd(Table.NAME, (Map)FieldMap.build((String)"author", (Object)author.getKey(), (String)"name", (Object)name));
        return this.convertGVToRequest(EntityUtil.getOnly((List)genericValues));
    }

    @Override
    public SearchRequest getSearchRequest(@Nonnull Long id) {
        return this.convertGVToRequest(this.findByPrimaryKey(id));
    }

    @Override
    public SearchRequest create(@Nonnull SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        Assertions.notNull((String)"request name", (Object)request.getName());
        String name = request.getName();
        String authorKey = request.getOwner() == null ? null : request.getOwner().getKey();
        GenericValue gv = this.delegator.createValue(Table.NAME, (Map)FieldMap.build((String)"name", (Object)name).add("nameLower", (Object)name.toLowerCase()).add("project", null).add("description", (Object)request.getDescription()).add("author", (Object)authorKey).add("user", (Object)authorKey).add("request", (Object)this.searchService.getJqlString(request.getQuery())).add("favCount", (Object)new Long(0L)));
        return this.convertGVToRequest(gv);
    }

    @Override
    public SearchRequest update(@Nonnull SearchRequest request) {
        Assertions.notNull((String)"request", (Object)request);
        GenericValue searchFilter = this.findByPrimaryKey(request.getId());
        Assertions.notNull((String)"request name", (Object)request.getName());
        String name = request.getName();
        searchFilter.setString("name", name);
        searchFilter.setString("nameLower", name.toLowerCase());
        searchFilter.setString("description", request.getDescription());
        searchFilter.setString("request", this.searchService.getJqlString(request.getQuery()));
        searchFilter.setString("author", ApplicationUsers.getKeyFor(request.getOwner()));
        searchFilter.remove((Object)"favCount");
        this.delegator.store(searchFilter);
        return this.getSearchRequest(request.getId());
    }

    @Override
    public SearchRequest adjustFavouriteCount(@Nonnull Long searchRequestId, int incrementValue) {
        Assertions.notNull((String)"searchRequestId", (Object)searchRequestId);
        GenericValue gv = this.findByPrimaryKey(searchRequestId);
        if (gv == null) {
            return null;
        }
        Long currentFavcount = gv.getLong("favCount");
        long newFavcount = currentFavcount == null ? 0L : currentFavcount;
        if ((newFavcount += (long)incrementValue) < 0L) {
            newFavcount = 0L;
        }
        gv.set("favCount", (Object)new Long(newFavcount));
        this.delegator.store(gv);
        return this.getSearchRequest(searchRequestId);
    }

    @Override
    public void delete(@Nonnull Long id) {
        GenericValue gv = this.findByPrimaryKey(id);
        if (gv == null) {
            throw new DataAccessException("SearchRequest does not exist.  Can not delete.");
        }
        this.delegator.removeValue(gv);
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(final Project project) {
        Assertions.notNull((String)"project", (Object)project);
        Long projectId = project.getId();
        return new DatabaseIterable<SearchRequest>(this.getSearchRequestCountForProject(projectId), this.searchRequestResolver){

            @Override
            protected OfBizListIterator createListIterator() {
                return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.NAME, (EntityCondition)new EntityExpr("project", EntityOperator.EQUALS, (Object)project.getId()));
            }
        };
    }

    @Override
    public List<SearchRequest> findByNameIgnoreCase(String name) {
        Select.WhereContext<GenericValue> selectQuery = Select.columns(new String[0]).from("SearchRequest").whereEqual("nameLower", name.toLowerCase());
        return selectQuery.runWith(this.delegator).consumeWith(new EntityListConsumer<GenericValue, List<SearchRequest>>(){
            List<SearchRequest> results = new ArrayList<SearchRequest>();

            @Override
            public void consume(GenericValue entity) {
                this.results.add((SearchRequest)OfBizSearchRequestStore.this.searchRequestResolver.get((Object)entity));
            }

            @Override
            public List<SearchRequest> result() {
                return this.results;
            }
        });
    }

    @Override
    public EnclosedIterable<SearchRequest> getSearchRequests(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        Resolver<GenericValue, SearchRequest> resolver = new Resolver<GenericValue, SearchRequest>(){

            public SearchRequest get(GenericValue sharedEntityGV) {
                GenericDelegator genericDelegator = sharedEntityGV.getDelegator();
                return OfBizSearchRequestStore.this.convertGVToRequest(genericDelegator.makeValue(Table.NAME, this.filter(sharedEntityGV.getAllFields())));
            }

            private final Map<String, ?> filter(Map<String, ?> fields) {
                HashMap result = new HashMap(fields);
                result.remove("param1");
                result.remove("param2");
                result.remove("entityId");
                result.remove("type");
                result.remove("entityType");
                return Collections.unmodifiableMap(result);
            }
        };
        final EntityExprList expr = new EntityExprList(EasyList.build((Object)new EntityExpr("type", EntityOperator.EQUALS, (Object)GroupShareType.TYPE.get()), (Object)new EntityExpr("param1", EntityOperator.EQUALS, (Object)group.getName())), EntityOperator.AND);
        return new DatabaseIterable<SearchRequest>(-1, (Resolver)resolver){

            @Override
            protected OfBizListIterator createListIterator() {
                return OfBizSearchRequestStore.this.delegator.findListIteratorByCondition(Table.SHARE, (EntityCondition)expr);
            }
        };
    }

    private GenericValue findByPrimaryKey(Long id) {
        return this.delegator.findById(Table.NAME, id);
    }

    private List<GenericValue> getSearchRequestGVsOwnedBy(String authorKey) {
        if (authorKey == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        entityExpressions.add(new EntityExpr("author", EntityOperator.EQUALS, (Object)authorKey));
        return this.delegator.findByOr(Table.NAME, entityExpressions, EasyList.build((Object)"name"));
    }

    private IndexableSharedEntity<SearchRequest> convertGVToIndexableSharedEntity(GenericValue requestGV) {
        if (requestGV == null) {
            return null;
        }
        ApplicationUser author = this.userManager.getUserByKey(requestGV.getString("author"));
        String name = requestGV.getString("name");
        String description = requestGV.getString("description");
        Long id = requestGV.getLong("id");
        Long favCount = requestGV.getLong("favCount");
        if (favCount == null) {
            favCount = 0L;
        }
        return new IndexableSharedEntity<SearchRequest>(id, name, description, SearchRequest.ENTITY_TYPE, author, favCount);
    }

    private SearchRequest convertGVToRequest(GenericValue requestGV) {
        if (requestGV == null) {
            return null;
        }
        Query query = this.getSearchQueryFromGv(requestGV);
        ApplicationUser author = this.userManager.getUserByKeyEvenWhenUnknown(requestGV.getString("author"));
        String name = requestGV.getString("name");
        String description = requestGV.getString("description");
        Long id = requestGV.getLong("id");
        Long favCount = requestGV.getLong("favCount");
        if (favCount == null) {
            favCount = 0L;
        }
        return new SearchRequest(query, author, name, description, id, favCount.longValue());
    }

    Query getSearchQueryFromGv(GenericValue searchRequestGv) {
        String queryString = searchRequestGv.getString("request");
        String jql = queryString == null ? "" : queryString;
        try {
            return this.jqlQueryParser.parseQuery(jql);
        }
        catch (JqlParseException e) {
            log.error("A JQL query exception was thrown parsing, error loading search request with id '" + searchRequestGv.getLong("id") + "' and name '" + searchRequestGv.getString("name") + "' owned by '" + searchRequestGv.getString("author") + "' query '" + jql + "'.");
            throw new DataAccessException((Throwable)e);
        }
    }

    private static final class Column {
        private static final String AUTHOR = "author";
        private static final String NAME = "name";
        private static final String NAME_LOWER = "nameLower";
        private static final String ID = "id";
        private static final String PROJECT = "project";
        private static final String DESCRIPTION = "description";
        private static final String USER = "user";
        private static final String REQUEST = "request";
        private static final String FAV_COUNT = "favCount";
        private static final String COUNT = "count";

        private Column() {
        }
    }

    static final class Table {
        static final String NAME = ENTITY_TYPE.getName();
        static final String COUNT = NAME + "Count";
        static final String SHARE = NAME + "ShareView";

        Table() {
        }
    }
}

