/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.status;

import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.google.common.base.Preconditions;
import org.ofbiz.core.entity.GenericValue;

public class StatusImpl
extends IssueConstantImpl
implements Status {
    private static final String STATUSCATEGORY = "statuscategory";
    private final StatusCategoryManager statusCategoryManager;

    public StatusImpl(GenericValue genericValue, TranslationManager translationManager, JiraAuthenticationContext authenticationContext, BaseUrl locator, StatusCategoryManager statusCategoryManager) {
        super(genericValue, translationManager, authenticationContext, locator);
        this.statusCategoryManager = statusCategoryManager;
    }

    public StatusCategory getStatusCategory() {
        if (!this.statusCategoryManager.isStatusAsLozengeEnabled()) {
            return null;
        }
        StatusCategory statusCategory = this.statusCategoryManager.getStatusCategory(this.getStatusCategoryId());
        if (statusCategory == null) {
            return this.statusCategoryManager.getDefaultStatusCategory();
        }
        return statusCategory;
    }

    public void setStatusCategory(StatusCategory statusCategory) {
        Long id = ((StatusCategory)Preconditions.checkNotNull((Object)statusCategory)).getId();
        this.genericValue.set(STATUSCATEGORY, (Object)id);
    }

    public Long getStatusCategoryId() {
        return this.genericValue.getLong(STATUSCATEGORY);
    }

    public SimpleStatus getSimpleStatus() {
        return new SimpleStatusImpl(this);
    }

    public SimpleStatus getSimpleStatus(I18nHelper i18nHelper) {
        return new SimpleStatusImpl(this, i18nHelper);
    }
}

