/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.AbstractIssueHtmlView;
import com.atlassian.jira.issue.views.SingleIssueWriter;
import com.atlassian.jira.issue.views.util.DefaultSearchRequestPreviousView;
import com.atlassian.jira.issue.views.util.SearchRequestPreviousView;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.plugin.JiraResourcedModuleDescriptor;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParams;
import com.atlassian.jira.plugin.searchrequestview.AbstractSearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractSearchRequestFullContentView
extends AbstractSearchRequestView {
    protected final ApplicationProperties applicationProperties;
    private SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil;
    private final SearchRequestPreviousView searchRequestPreviousView;
    private static final String PAGE_BREAK_HTML = "<br /><br style='page-break-before:always;'/><br />";
    private static final String HR_CLASS_FULLCONTENT = "<hr class='fullcontent'>";

    public AbstractSearchRequestFullContentView(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil) {
        this.applicationProperties = applicationProperties;
        this.searchRequestViewBodyWriterUtil = searchRequestViewBodyWriterUtil;
        this.searchRequestPreviousView = new DefaultSearchRequestPreviousView(authenticationContext, applicationProperties);
    }

    public void writeSearchResults(SearchRequest searchRequest, final SearchRequestParams searchRequestParams, Writer writer) {
        AbstractIssueHtmlView issueView = (AbstractIssueHtmlView)SearchRequestViewUtils.getIssueView(this.getIssueViewClass());
        try {
            if (issueView == null) {
                writer.write("Could not find plugin of class '" + this.getIssueViewClass() + "'.  This is needed for this plugin to work");
                return;
            }
            String title = SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getString("jira.title"));
            String linkToPrevious = null;
            if (this.showLinkToIssueNavigator()) {
                linkToPrevious = this.searchRequestPreviousView.getLinkToPrevious(searchRequest, (JiraResourcedModuleDescriptor<?>)this.descriptor);
            }
            writer.write(issueView.getHeader(title, linkToPrevious));
            SingleIssueWriter singleIssueWriter = new SingleIssueWriter(){

                @Override
                public void writeIssue(Issue issue, AbstractIssueView issueView, Writer writer) throws IOException {
                    writer.write(issueView.getBody(issue, (IssueViewRequestParams)searchRequestParams));
                    writer.write(AbstractSearchRequestFullContentView.HR_CLASS_FULLCONTENT);
                    if (AbstractSearchRequestFullContentView.this.applicationProperties.getOption("jira.search.fullcontentview.pagebreaks")) {
                        writer.write(AbstractSearchRequestFullContentView.PAGE_BREAK_HTML);
                    }
                }
            };
            this.searchRequestViewBodyWriterUtil.writeBody(writer, issueView, searchRequest, singleIssueWriter, searchRequestParams.getPagerFilter());
            writer.write(issueView.getFooter(null));
        }
        catch (SearchException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected abstract Class getIssueViewClass();

    protected abstract boolean showLinkToIssueNavigator();
}

