/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.jira.bc.issue.worklog.DeletedWorklog;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.worklog.QueryDSLWorklogFactory;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogImpl2;
import com.atlassian.jira.issue.worklog.WorklogStore;
import com.atlassian.jira.model.querydsl.QChangeGroup;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.model.querydsl.QProjectRole;
import com.atlassian.jira.model.querydsl.QWorklog;
import com.atlassian.jira.model.querydsl.WorklogDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.mysema.query.Tuple;
import com.mysema.query.dml.StoreClause;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.QTuple;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.path.StringPath;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class DatabaseWorklogStore
implements WorklogStore {
    public static final String WORKLOG_ENTITY = "Worklog";
    private static final QTuple WORKLOG_PROJECT_ROLE_TUPLE = new QTuple(ImmutableList.builder().addAll((Iterable)Lists.newArrayList((Object[])QWorklog.WORKLOG.all())).addAll((Iterable)Lists.newArrayList((Object[])QProjectRole.PROJECT_ROLE.all())).build());
    private static final QTuple WORKLOG_ALIASED_PROJECT_ROLE_TUPLE = new QTuple(ImmutableList.builder().addAll(DatabaseWorklogStore.worklogColumnsWithAliasedId()).addAll((Iterable)Lists.newArrayList((Object[])QProjectRole.PROJECT_ROLE.all())).build());
    private final OfBizDelegator delegator;
    private final DbConnectionManager dbConnectionManager;
    private final QueryDSLWorklogFactory queryDSLWorklogFactory;
    private final DatabaseConfigurationManager databaseConfigurationManager;

    private static List<Expression<?>> worklogColumnsWithAliasedId() {
        ArrayList paths = Lists.newArrayList((Object[])QWorklog.WORKLOG.all());
        paths.replaceAll(new UnaryOperator<Expression<?>>(){

            @Override
            public Expression<?> apply(Expression<?> expression) {
                if (expression.equals(QWorklog.WORKLOG.id)) {
                    return QWorklog.WORKLOG.id.as("WORKLOG_ID");
                }
                return expression;
            }
        });
        return paths;
    }

    public DatabaseWorklogStore(OfBizDelegator delegator, DbConnectionManager dbConnectionManager, QueryDSLWorklogFactory queryDSLWorklogFactory, DatabaseConfigurationManager databaseConfigurationManager) {
        this.delegator = delegator;
        this.dbConnectionManager = dbConnectionManager;
        this.queryDSLWorklogFactory = queryDSLWorklogFactory;
        this.databaseConfigurationManager = databaseConfigurationManager;
    }

    @Override
    public Worklog update(Worklog worklog) {
        WorklogDTO worklogDTO = this.dbConnectionManager.executeQuery(dbConnection -> (WorklogDTO)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QWorklog.WORKLOG)).where((Predicate)QWorklog.WORKLOG.id.eq((Object)worklog.getId()))).singleResult((Expression)QWorklog.WORKLOG));
        if (worklogDTO == null) {
            throw new IllegalArgumentException("Could not find original worklog entity to update.");
        }
        this.dbConnectionManager.execute(dbConnection -> this.setWorklogFields(dbConnection.update((RelationalPath<?>)QWorklog.WORKLOG), worklog).where((Predicate)QWorklog.WORKLOG.id.eq((Object)worklog.getId())).execute());
        return this.getById(worklog.getId());
    }

    @Override
    public Worklog create(Worklog worklog) {
        Long nextId = this.delegator.getDelegatorInterface().getNextSeqId(QWorklog.WORKLOG.getEntityName());
        this.dbConnectionManager.executeQuery(dbConnection -> ((SQLInsertClause)this.setWorklogFields(dbConnection.insert(QWorklog.WORKLOG), worklog)).set(QWorklog.WORKLOG.id, (Object)nextId).execute());
        return new WorklogImpl2(worklog.getIssue(), nextId, worklog.getAuthorKey(), worklog.getComment(), worklog.getStartDate(), worklog.getGroupLevel(), worklog.getRoleLevelId(), worklog.getTimeSpent(), worklog.getUpdateAuthorKey(), worklog.getCreated(), worklog.getUpdated(), worklog.getRoleLevel());
    }

    private <T extends StoreClause<T>> T setWorklogFields(T storeClause, Worklog worklog) {
        Preconditions.checkArgument((worklog != null ? 1 : 0) != 0, (Object)"Cannot store a null worklog.");
        Preconditions.checkArgument((worklog.getIssue() != null ? 1 : 0) != 0, (Object)"Cannot store a worklog against a null issue.");
        return (T)storeClause.set(QWorklog.WORKLOG.issue, (Object)worklog.getIssue().getId()).set((Path)QWorklog.WORKLOG.author, (Object)worklog.getAuthorKey()).set((Path)QWorklog.WORKLOG.updateauthor, (Object)worklog.getUpdateAuthorKey()).set((Path)QWorklog.WORKLOG.body, (Object)worklog.getComment()).set((Path)QWorklog.WORKLOG.grouplevel, (Object)worklog.getGroupLevel()).set(QWorklog.WORKLOG.rolelevel, (Object)worklog.getRoleLevelId()).set(QWorklog.WORKLOG.timeworked, (Object)worklog.getTimeSpent()).set(QWorklog.WORKLOG.startdate, (Object)new Timestamp(worklog.getStartDate().getTime())).set(QWorklog.WORKLOG.created, (Object)new Timestamp(worklog.getCreated().getTime())).set(QWorklog.WORKLOG.updated, (Object)new Timestamp(worklog.getUpdated().getTime()));
    }

    @Override
    public boolean delete(Long worklogId) {
        Preconditions.checkArgument((worklogId != null ? 1 : 0) != 0, (Object)"Cannot remove a worklog with id null.");
        return this.dbConnectionManager.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QWorklog.WORKLOG).where((Predicate)QWorklog.WORKLOG.id.eq((Object)worklogId)).execute()) == 1L;
    }

    @Override
    public Worklog getById(Long id) {
        if (id == null) {
            return null;
        }
        Tuple worklogTuple = this.dbConnectionManager.executeQuery(dc -> (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dc.newSqlQuery().from((Expression)QWorklog.WORKLOG)).leftJoin((EntityPath)QProjectRole.PROJECT_ROLE)).on((Predicate)QProjectRole.PROJECT_ROLE.id.eq(QWorklog.WORKLOG.rolelevel))).where((Predicate)QWorklog.WORKLOG.id.eq((Object)id))).singleResult((Expression)WORKLOG_ALIASED_PROJECT_ROLE_TUPLE));
        return this.queryDSLWorklogFactory.createWorklogWithAliasedIdColumn(worklogTuple);
    }

    @Override
    public List<Worklog> getByIssue(Issue issue) {
        Preconditions.checkArgument((issue != null ? 1 : 0) != 0, (Object)"Cannot resolve worklogs for null issue.");
        BooleanExpression query = issue.getId() != null ? QWorklog.WORKLOG.issue.eq((Object)issue.getId()) : QWorklog.WORKLOG.issue.isNull();
        return this.dbConnectionManager.executeQuery(dc -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dc.newSqlQuery().from((Expression)QWorklog.WORKLOG)).leftJoin((EntityPath)QProjectRole.PROJECT_ROLE)).on((Predicate)QProjectRole.PROJECT_ROLE.id.eq(QWorklog.WORKLOG.rolelevel))).where((Predicate)query)).orderBy(QWorklog.WORKLOG.created.asc())).list((Expression)WORKLOG_PROJECT_ROLE_TUPLE)).stream().map(t -> this.queryDSLWorklogFactory.createWorklog(issue, (Tuple)t)).collect(Collectors.toList());
    }

    @Override
    public int swapWorklogGroupRestriction(String groupName, String swapGroup) {
        Preconditions.checkArgument((groupName != null ? 1 : 0) != 0, (Object)"You must provide a non null group name.");
        Preconditions.checkArgument((swapGroup != null ? 1 : 0) != 0, (Object)"You must provide a non null swap group name.");
        return Ints.checkedCast((long)this.dbConnectionManager.executeQuery(dc -> dc.update((RelationalPath<?>)QWorklog.WORKLOG).set((Path)QWorklog.WORKLOG.grouplevel, (Object)swapGroup).where((Predicate)QWorklog.WORKLOG.grouplevel.eq((Object)groupName)).execute()));
    }

    @Override
    public long getCountForWorklogsRestrictedByGroup(String groupName) {
        Preconditions.checkArgument((groupName != null ? 1 : 0) != 0, (Object)"You must provide a non null group name.");
        return this.dbConnectionManager.executeQuery(dc -> ((SQLQuery)((SQLQuery)dc.newSqlQuery().from((Expression)QWorklog.WORKLOG)).where((Predicate)QWorklog.WORKLOG.grouplevel.eq((Object)groupName))).count());
    }

    @Override
    public long getCountForWorklogsRestrictedByRole(Long roleId) {
        Preconditions.checkNotNull((Object)roleId, (Object)"You must provide a non null role id.");
        return this.dbConnectionManager.executeQuery(dc -> ((SQLQuery)((SQLQuery)dc.newSqlQuery().from((Expression)QWorklog.WORKLOG)).where((Predicate)QWorklog.WORKLOG.rolelevel.eq((Object)roleId))).count());
    }

    @Override
    public int swapWorklogRoleRestriction(Long roleId, Long swapRoleId) {
        Preconditions.checkNotNull((Object)roleId, (Object)"You must provide a non null role id.");
        Preconditions.checkNotNull((Object)swapRoleId, (Object)"You must provide a non null swap role id.");
        return Ints.checkedCast((long)this.dbConnectionManager.executeQuery(dc -> dc.update((RelationalPath<?>)QWorklog.WORKLOG).set(QWorklog.WORKLOG.rolelevel, (Object)swapRoleId).where((Predicate)QWorklog.WORKLOG.rolelevel.eq((Object)roleId)).execute()));
    }

    @Override
    public List<Worklog> getWorklogsUpdateSince(Long sinceInMiliseconds, int maxResults) {
        return this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QWorklog.WORKLOG)).leftJoin((EntityPath)QProjectRole.PROJECT_ROLE)).on((Predicate)QProjectRole.PROJECT_ROLE.id.eq(QWorklog.WORKLOG.rolelevel))).where((Predicate)QWorklog.WORKLOG.updated.goe((Comparable)new Timestamp(sinceInMiliseconds)).and((Predicate)QWorklog.WORKLOG.updated.loe((Comparable)new Timestamp(this.minuteAgo()))))).orderBy(QWorklog.WORKLOG.updated.asc())).limit((long)maxResults)).list((Expression)WORKLOG_ALIASED_PROJECT_ROLE_TUPLE)).stream().map(this.queryDSLWorklogFactory::createWorklogWithAliasedIdColumn).collect(Collectors.toList());
    }

    @Override
    public List<DeletedWorklog> getWorklogsDeletedSince(Long sinceInMilliseconds, int maxResults) {
        QChangeItem ci = QChangeItem.CHANGE_ITEM;
        QChangeGroup cg = QChangeGroup.CHANGE_GROUP;
        QWorklog w = QWorklog.WORKLOG;
        NumberExpression oldValueExpression = this.isOracle() ? this.convertToNumber(ci.oldvalue) : ci.oldvalue.castToNum(Long.class);
        List<Tuple> removedWorklogs = this.getRemovedWorklogs(sinceInMilliseconds, maxResults, ci, cg, w, (NumberExpression<Long>)oldValueExpression);
        return removedWorklogs.stream().map(t -> new DeletedWorklog((Long)t.get((Expression)oldValueExpression), new Date(((Timestamp)t.get((Expression)cg.created.max())).getTime()))).collect(Collectors.toList());
    }

    @Override
    public Set<Worklog> getWorklogsForIds(Set<Long> worklogIds, int maxResults) {
        return this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QWorklog.WORKLOG)).leftJoin((EntityPath)QProjectRole.PROJECT_ROLE)).on((Predicate)QProjectRole.PROJECT_ROLE.id.eq(QWorklog.WORKLOG.rolelevel))).where((Predicate)QWorklog.WORKLOG.id.in((Collection)worklogIds))).limit((long)maxResults)).list((Expression)WORKLOG_ALIASED_PROJECT_ROLE_TUPLE)).stream().map(this.queryDSLWorklogFactory::createWorklogWithAliasedIdColumn).collect(Collectors.toSet());
    }

    private long minuteAgo() {
        return new DateTime(System.currentTimeMillis()).minusMinutes(1).getMillis();
    }

    private boolean isOracle() {
        return this.databaseConfigurationManager.getDatabaseConfiguration().isOracle();
    }

    private List<Tuple> getRemovedWorklogs(Long sinceInMilliseconds, int maxResults, QChangeItem ci, QChangeGroup cg, QWorklog w, NumberExpression<Long> oldValueExpression) {
        return this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)ci)).leftJoin((EntityPath)cg)).on((Predicate)ci.group.eq(cg.id))).where((Predicate)ci.field.eq((Object)"WorklogId").and((Predicate)cg.created.goe((Comparable)new Timestamp(sinceInMilliseconds)).and((Predicate)cg.created.loe((Comparable)new Timestamp(this.minuteAgo())))).and((Predicate)oldValueExpression.notIn((CollectionExpression)((SQLSubQuery)new SQLSubQuery().from((Expression)w)).list(w.id))))).groupBy((Expression)oldValueExpression)).orderBy(cg.created.max().asc())).limit((long)maxResults)).list(new Expression[]{oldValueExpression, cg.created.max()}));
    }

    private NumberExpression<Long> convertToNumber(StringPath value) {
        return Expressions.numberTemplate(Long.class, (String)"TO_NUMBER({0})", (Object[])new Object[]{value});
    }
}

