/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.permission.DefaultOperandSanitisingVisitor;
import com.atlassian.jira.jql.permission.LiteralSanitiser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.List;

abstract class AbstractLiteralSanitisingVisitor
extends DefaultOperandSanitisingVisitor {
    private final JqlOperandResolver jqlOperandResolver;
    private final ApplicationUser user;
    private final TerminalClause terminalClause;

    AbstractLiteralSanitisingVisitor(JqlOperandResolver jqlOperandResolver, ApplicationUser user, TerminalClause terminalClause) {
        super(jqlOperandResolver, user);
        this.jqlOperandResolver = jqlOperandResolver;
        this.user = user;
        this.terminalClause = terminalClause;
    }

    @Override
    public Operand visit(SingleValueOperand singleValueOperand) {
        List literals = this.jqlOperandResolver.getValues(this.user, (Operand)singleValueOperand, this.terminalClause);
        if (literals == null) {
            return singleValueOperand;
        }
        LiteralSanitiser.Result result = this.createLiteralSanitiser().sanitiseLiterals(literals);
        if (!result.isModified()) {
            return singleValueOperand;
        }
        List<QueryLiteral> resultantLiterals = result.getLiterals();
        if (resultantLiterals.size() == 1) {
            return new SingleValueOperand(resultantLiterals.get(0));
        }
        return MultiValueOperand.ofQueryLiterals(resultantLiterals);
    }

    protected abstract LiteralSanitiser createLiteralSanitiser();
}

