/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public abstract class ConstantsNameResolver<T>
implements NameResolver<T> {
    private final ConstantsManager constantsManager;
    private final String constantName;

    public ConstantsNameResolver(ConstantsManager constantsManager, String constantName) {
        this.constantsManager = constantsManager;
        this.constantName = constantName;
    }

    public List<String> getIdsFromName(String name) {
        IssueConstant constant = this.constantsManager.getConstantByNameIgnoreCase(this.constantName, name);
        if (constant != null) {
            return Lists.newArrayList((Object[])new String[]{constant.getId()});
        }
        return Collections.emptyList();
    }

    public boolean nameExists(String name) {
        return this.constantsManager.getConstantByNameIgnoreCase(this.constantName, name) != null;
    }

    public boolean idExists(Long id) {
        return this.get(id) != null;
    }

    public T get(Long id) {
        return (T)this.constantsManager.getConstantObject(this.constantName, id.toString());
    }
}

