/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.index.property.JqlAliasManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.validator.OrderByValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SearchSort;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InjectableComponent
public class DefaultOrderByValidator
implements OrderByValidator {
    private final SearchHandlerManager searchHandlerManager;
    private final FieldManager fieldManager;
    private final I18nHelper.BeanFactory iBeanFactory;
    private final JqlAliasManager jqlAliasManager;

    public DefaultOrderByValidator(SearchHandlerManager searchHandlerManager, FieldManager fieldManager, I18nHelper.BeanFactory iBeanFactory, JqlAliasManager jqlAliasManager) {
        this.searchHandlerManager = searchHandlerManager;
        this.fieldManager = fieldManager;
        this.iBeanFactory = iBeanFactory;
        this.jqlAliasManager = jqlAliasManager;
    }

    @Override
    public MessageSet validate(ApplicationUser searcher, OrderBy orderBy) {
        MessageSetImpl messageSet = new MessageSetImpl();
        List searchSorts = orderBy.getSearchSorts();
        HashMap<String, String> fieldToJqlNames = new HashMap<String, String>();
        for (SearchSort searchSort : searchSorts) {
            String clauseName = searchSort.getField();
            if (EntityPropertyType.isJqlClause((String)clauseName) || this.jqlAliasManager.isJqlAlias(clauseName)) continue;
            Collection fieldIds = this.searchHandlerManager.getFieldIds(searcher, clauseName);
            if (fieldIds.isEmpty()) {
                messageSet.addErrorMessage(this.getI18n(searcher).getText("jira.jql.order.by.field.is.not.orderable", clauseName));
                continue;
            }
            if (!this.fieldsAreSortable(fieldIds)) {
                messageSet.addErrorMessage(this.getI18n(searcher).getText("jira.jql.order.by.field.not.supported", clauseName));
                continue;
            }
            this.validateSortUnique(searcher, (MessageSet)messageSet, fieldToJqlNames, fieldIds, clauseName);
        }
        return messageSet;
    }

    private void validateSortUnique(ApplicationUser searcher, MessageSet messageSet, Map<String, String> fieldIdToClauseName, Collection<String> fieldIds, String clause) {
        for (String fieldId : fieldIds) {
            String origClauseName = fieldIdToClauseName.get(fieldId);
            if (origClauseName != null) {
                if (origClauseName.equals(clause)) {
                    messageSet.addErrorMessage(this.getI18n(searcher).getText("jira.jql.order.by.field.is.duplicate", clause));
                    continue;
                }
                messageSet.addErrorMessage(this.getI18n(searcher).getText("jira.jql.order.by.field.is.twice", clause, origClauseName));
                continue;
            }
            fieldIdToClauseName.put(fieldId, clause);
        }
    }

    private boolean fieldsAreSortable(Collection<String> fieldIds) {
        for (String fieldId : fieldIds) {
            NavigableField field;
            if (!this.fieldManager.isNavigableField(fieldId) || (field = this.fieldManager.getNavigableField(fieldId)).getSortFields(false).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.iBeanFactory.getInstance(user);
    }
}

