/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.resolver.SavedFilterResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@InjectableComponent
public class SavedFilterCycleDetector {
    private final SavedFilterResolver savedFilterResolver;
    private final JqlOperandResolver jqlOperandResolver;

    public SavedFilterCycleDetector(SavedFilterResolver savedFilterResolver, JqlOperandResolver jqlOperandResolver) {
        this.savedFilterResolver = (SavedFilterResolver)Assertions.notNull((String)"savedFilterResolver", (Object)savedFilterResolver);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
    }

    public boolean containsSavedFilterReference(ApplicationUser searcher, boolean overrideSecurity, SearchRequest savedFilter, Long filterId) {
        Assertions.notNull((String)"savedFilter", (Object)savedFilter);
        return new DepthFirstWalker(searcher, overrideSecurity).walk(savedFilter, filterId);
    }

    private class DepthFirstWalker {
        private final QueryCreationContext creationContext;

        private DepthFirstWalker(ApplicationUser searcher, boolean overrideSecurity) {
            this.creationContext = new QueryCreationContextImpl(searcher, overrideSecurity);
        }

        private boolean walk(SearchRequest request, Long filterId) {
            HashSet path = Sets.newHashSet();
            if (filterId != null) {
                path.add(filterId);
            }
            return this.visitSearchRequest(request, path, Sets.newHashSet());
        }

        private boolean visitClause(Clause clause, Set<Long> path, Set<Long> visited) {
            if (clause == null) {
                return false;
            }
            for (TerminalClause nestedFilterClause : this.getFilterClauses(clause)) {
                for (SearchRequest matchingSearchRequest : this.getSearchRequests(this.creationContext, nestedFilterClause)) {
                    if (!this.visitSearchRequest(matchingSearchRequest, path, visited)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean visitSearchRequest(SearchRequest filter, Set<Long> path, Set<Long> visited) {
            if (filter == null) {
                return false;
            }
            if (visited.contains(filter.getId())) {
                return false;
            }
            if (!path.add(filter.getId())) {
                return true;
            }
            if (this.visitClause(filter.getQuery().getWhereClause(), path, visited)) {
                return true;
            }
            path.remove(filter.getId());
            visited.add(filter.getId());
            return false;
        }

        private List<SearchRequest> getSearchRequests(QueryCreationContext creationContext, TerminalClause clause) {
            List filterValues = SavedFilterCycleDetector.this.jqlOperandResolver.getValues(creationContext, clause.getOperand(), clause);
            return creationContext.isSecurityOverriden() ? SavedFilterCycleDetector.this.savedFilterResolver.getSearchRequestOverrideSecurity(filterValues) : SavedFilterCycleDetector.this.savedFilterResolver.getSearchRequest(creationContext.getUser(), filterValues);
        }

        private List<TerminalClause> getFilterClauses(Clause clause) {
            if (clause == null) {
                return Collections.emptyList();
            }
            NamedTerminalClauseCollectingVisitor collectingVisitor = new NamedTerminalClauseCollectingVisitor((Collection)SystemSearchConstants.forSavedFilter().getJqlClauseNames().getJqlFieldNames());
            clause.accept((ClauseVisitor)collectingVisitor);
            return collectingVisitor.getNamedClauses();
        }
    }
}

