/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.jira.plugin.PluginInjector;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.CacheableContextProviderDecorator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.impl.AbstractDelegatingPlugin;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraWebFragmentHelper
implements WebFragmentHelper {
    private static final Logger log = LoggerFactory.getLogger(JiraWebFragmentHelper.class);
    private final VelocityTemplatingEngine templatingEngine;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public JiraWebFragmentHelper(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.templatingEngine = templatingEngine;
        this.authenticationContext = authenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    public Condition loadCondition(String className, Plugin plugin) throws ConditionLoadingException {
        try {
            Class conditionClass = plugin.loadClass(className, this.getClass());
            return (Condition)PluginInjector.newInstance(conditionClass, plugin);
        }
        catch (Exception e) {
            throw new ConditionLoadingException("Could not load '" + className + "' in plugin " + plugin, (Throwable)e);
        }
    }

    public ContextProvider loadContextProvider(String className, Plugin plugin) throws ConditionLoadingException {
        try {
            ContextProvider contextProvider;
            Class providerClass = plugin.loadClass(className, this.getClass());
            if (plugin instanceof AbstractDelegatingPlugin) {
                plugin = ((AbstractDelegatingPlugin)plugin).getDelegate();
            }
            if ((contextProvider = (ContextProvider)PluginInjector.newInstance(providerClass, plugin)) instanceof CacheableContextProvider) {
                return new CacheableContextProviderDecorator((CacheableContextProvider)contextProvider);
            }
            return contextProvider;
        }
        catch (Exception e) {
            throw new ConditionLoadingException("Could not load '" + className + "' in plugin " + plugin, (Throwable)e);
        }
    }

    public String getI18nValue(String key, List arguments, Map context) {
        block3: {
            Object i18nObject = context.get("i18n");
            if (i18nObject != null) {
                try {
                    return ((I18nHelper)i18nObject).getText(key, (Object)arguments);
                }
                catch (ClassCastException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Expected an instance of I18nHelper in the context under key: 'i18n' but it was " + i18nObject.getClass(), (Throwable)e);
                }
            }
        }
        return this.authenticationContext.getI18nHelper().getText(key, (Object)arguments);
    }

    public String renderVelocityFragment(String fragment, Map<String, Object> context) {
        if (!this.needToRender(fragment)) {
            return fragment;
        }
        return this.getPlainText(fragment, this.getDefaultParams(context));
    }

    String getPlainText(String fragment, Map<String, Object> startingParams) {
        try {
            if (StringUtils.isNotBlank((String)fragment)) {
                return this.templatingEngine.render(TemplateSources.fragment((String)fragment)).applying(startingParams).asPlainText();
            }
        }
        catch (VelocityException e) {
            log.error("Error while rendering velocity fragment: '" + fragment + "'.", (Throwable)e);
        }
        return "";
    }

    private Map<String, Object> getDefaultParams(Map<String, Object> startingParams) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
    }

    private boolean needToRender(String velocity) {
        return StringUtils.isNotBlank((String)velocity) && (velocity.contains("$") || velocity.contains("#"));
    }

    private String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }
}

