/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webpanel.notification;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class UserLimitExceededContextProvider
implements ContextProvider {
    private final ApplicationRoleManager applicationRoleManager;
    private final BaseUrl baseUrl;

    public UserLimitExceededContextProvider(ApplicationRoleManager applicationRoleManager, BaseUrl baseUrl) {
        this.baseUrl = baseUrl;
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
    }

    public void init(Map<String, String> map) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        if (!this.applicationRoleManager.isAnyRoleLimitExceeded()) {
            throw new IllegalStateException("Application roles are not exceeded  - user limit exceeded context provider should not be called");
        }
        List affectedRoles = (List)this.getAffectedRoles().collect(CollectorsUtil.toImmutableList());
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder().put((Object)"baseUrl", (Object)this.baseUrl.getBaseUrl());
        boolean justOne = this.applicationRoleManager.rolesEnabled() && affectedRoles.size() == 1;
        contextBuilder.put((Object)"justOne", (Object)justOne);
        if (justOne) {
            ApplicationRole applicationRole = (ApplicationRole)affectedRoles.stream().findFirst().get();
            contextBuilder.put((Object)"roleName", (Object)applicationRole.getName());
            contextBuilder.put((Object)"roleKey", (Object)applicationRole.getKey().value());
        }
        return contextBuilder.build();
    }

    private Stream<ApplicationRole> getAffectedRoles() {
        return this.applicationRoleManager.getRoles().stream().filter(r -> this.applicationRoleManager.isRoleLimitExceeded(r.getKey()));
    }
}

