/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.DefaultAssigneeException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProjectManager
implements ProjectManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractProjectManager.class);
    final UserManager userManager;
    private final ApplicationProperties applicationProperties;

    public AbstractProjectManager(UserManager userManager, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
    }

    public Project getProjectByCurrentKey(String projectKey) {
        return this.getProjectObjByKey(projectKey);
    }

    public ProjectCategory getProjectCategoryObjectByName(String projectCategoryName) throws DataAccessException {
        if (projectCategoryName == null) {
            return null;
        }
        for (ProjectCategory projectCategory : this.getAllProjectCategories()) {
            if (!projectCategoryName.equals(projectCategory.getName())) continue;
            return projectCategory;
        }
        return null;
    }

    public ProjectCategory getProjectCategoryObjectByNameIgnoreCase(String projectCategoryName) throws DataAccessException {
        if (projectCategoryName == null) {
            return null;
        }
        for (ProjectCategory projectCategory : this.getAllProjectCategories()) {
            if (!projectCategoryName.equalsIgnoreCase(projectCategory.getName())) continue;
            return projectCategory;
        }
        return null;
    }

    public List<Project> convertToProjectObjects(Collection<Long> projectIds) {
        if (projectIds == null) {
            return null;
        }
        ArrayList<Project> projects = new ArrayList<Project>(projectIds.size());
        for (Long id : projectIds) {
            Project project = this.getProjectObj(id);
            if (project == null) continue;
            projects.add(project);
        }
        return projects;
    }

    public ApplicationUser getDefaultAssignee(Project project, ProjectComponent component) {
        if (component == null) {
            return this.getDefaultAssignee(project, Collections.emptyList());
        }
        return this.getDefaultAssignee(project, Collections.singleton(component));
    }

    public ApplicationUser getDefaultAssignee(Project project, Collection<ProjectComponent> components) throws DefaultAssigneeException {
        ApplicationUser defaultAssignee = this.getConfiguredDefaultAssignee(project, components);
        if (defaultAssignee == null) {
            if (this.applicationProperties.getOption("jira.option.allowunassigned")) {
                return null;
            }
            throw new DefaultAssigneeException("Invalid default assignee for project '" + project.getKey() + "'. Unassigned issues not allowed.");
        }
        return defaultAssignee;
    }

    private ApplicationUser getConfiguredDefaultAssignee(Project project, Collection<ProjectComponent> components) throws DefaultAssigneeException {
        boolean useProjectLead = false;
        boolean useUnassigned = false;
        for (ProjectComponent component : components) {
            long assigneeType = component.getAssigneeType();
            if (assigneeType == 1L) {
                try {
                    return this.getDefaultAssignee(project, component.getLead());
                }
                catch (InvalidAssigneeException ex) {
                    log.warn("Unable to assign default assignee for " + project.getKey() + " component '" + component.getName() + "'. " + ex.getMessage());
                    continue;
                }
            }
            if (assigneeType == 2L) {
                useProjectLead = true;
                continue;
            }
            if (assigneeType != 3L) continue;
            useUnassigned = true;
        }
        if (useProjectLead) {
            return this.useProjectLeadAsDefaultAssignee(project);
        }
        if (useUnassigned) {
            return null;
        }
        Long projectAssigneeType = project.getAssigneeType();
        if (projectAssigneeType != null && projectAssigneeType == 3L) {
            return null;
        }
        return this.useProjectLeadAsDefaultAssignee(project);
    }

    private ApplicationUser useProjectLeadAsDefaultAssignee(Project project) {
        try {
            return this.getDefaultAssignee(project, project.getLeadUserKey());
        }
        catch (InvalidAssigneeException ex) {
            log.warn("Unable to assign default assignee for project " + project.getKey() + ". " + ex.getMessage());
            throw new DefaultAssigneeException(ex.getMessage());
        }
    }

    private ApplicationUser getDefaultAssignee(Project project, String userkey) throws InvalidAssigneeException {
        if (userkey == null) {
            throw new InvalidAssigneeException("Lead user not configured.");
        }
        ApplicationUser assignee = this.userManager.getUserByKey(userkey);
        if (assignee == null) {
            throw new InvalidAssigneeException("Cannot find user '" + userkey + "'.");
        }
        if (AbstractProjectManager.isUserAssignable(project, assignee)) {
            return assignee;
        }
        throw new InvalidAssigneeException("User '" + userkey + "' does not have assign permission.");
    }

    private static boolean isUserAssignable(Project project, ApplicationUser user) {
        return ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ASSIGNABLE_USER, project, user);
    }

    public Project updateProject(Project updatedProject, String name, String description, String lead, String url, Long assigneeType) {
        return this.updateProject(updatedProject, name, description, lead, url, assigneeType, null);
    }

    public Project updateProject(Project updatedProject, String name, String description, String lead, String url, Long assigneeType, Long avatarId) {
        return this.updateProject(updatedProject, name, description, lead, url, assigneeType, avatarId, null);
    }

    private class InvalidAssigneeException
    extends Exception {
        public InvalidAssigneeException(String message) {
            super(message);
        }
    }
}

