/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.project.type.BrowseProjectTypeManager;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.atlassian.jira.project.type.ProjectTypesDarkFeature;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;

public class ProjectTypesLinkFactory
implements WebItemProvider {
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final BrowseProjectTypeManager browseProjectTypeManager;
    private final ProjectTypesDarkFeature projectTypeDarkFeature;
    private final JiraAuthenticationContext authenticationContext;
    static final String USER = "user";
    static final String ID_PREFIX = "project_type_";
    static final String MENU_SECTION = "browse_link/project_types_main";
    static final String ICON_URL = "iconUrl";
    static final String ICON_PREFIX = "data:image/svg+xml;base64,";
    static final String RELATIVE_URL = "/secure/BrowseProjects.jspa";
    public static final String SELECTED_CATEGORY = "selectedCategory";
    public static final String ALL = "all";
    public static final String SELECTED_PROJECT_TYPE = "selectedProjectType";

    public ProjectTypesLinkFactory(VelocityRequestContextFactory velocityRequestContextFactory, BrowseProjectTypeManager browseProjectTypeManager, ProjectTypesDarkFeature projectTypesDarkFeature, JiraAuthenticationContext authenticationContext) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.browseProjectTypeManager = browseProjectTypeManager;
        this.projectTypeDarkFeature = projectTypesDarkFeature;
        this.authenticationContext = authenticationContext;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        if (!this.projectTypeDarkFeature.isEnabled()) {
            return Lists.newArrayList();
        }
        return this.convertToWebItems(this.browseProjectTypeManager.getAllProjectTypes((ApplicationUser)context.get(USER)));
    }

    private List<WebItem> convertToWebItems(List<ProjectType> projectTypes) {
        return (List)projectTypes.stream().map(projectType -> new WebFragmentBuilder(projectType.getWeight()).id(ID_PREFIX + projectType.getKey().getKey()).label(ProjectTypeKeyFormatter.format((ProjectTypeKey)projectType.getKey())).title(this.authenticationContext.getI18nHelper().getText(projectType.getDescriptionI18nKey())).addParam(ICON_URL, ICON_PREFIX + projectType.getIcon()).webItem(MENU_SECTION).url(this.linkUrl(projectType.getKey().getKey())).build()).collect(CollectorsUtil.toImmutableList());
    }

    private String linkUrl(String key) {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        UrlBuilder urlBuilder = new UrlBuilder(requestContext.getBaseUrl() + RELATIVE_URL);
        urlBuilder.addParameter(SELECTED_CATEGORY, ALL);
        urlBuilder.addParameter(SELECTED_PROJECT_TYPE, key);
        return urlBuilder.asUrlString();
    }
}

