/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.hook.WorkflowSchemeTemplate;
import com.atlassian.jira.project.template.hook.WorkflowTemplate;
import com.atlassian.jira.project.template.hook.WorkflowTemplateImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowSchemeTemplateImpl
implements WorkflowSchemeTemplate {
    private final String name;
    private final String description;
    private final Optional<String> defaultWorkflow;
    private final List<? extends WorkflowTemplate> workflowTemplates;

    public WorkflowSchemeTemplateImpl(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="default-workflow") String defaultWorkflow, @JsonProperty(value="workflows") List<WorkflowTemplateImpl> workflowTemplates) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = Strings.nullToEmpty((String)description);
        this.defaultWorkflow = defaultWorkflow == null ? Optional.empty() : Optional.of(defaultWorkflow.toUpperCase());
        this.workflowTemplates = (List)Preconditions.checkNotNull(workflowTemplates);
        this.validate();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Optional<String> defaultWorkflow() {
        return this.defaultWorkflow;
    }

    public List<WorkflowTemplate> workflowTemplates() {
        return Collections.unmodifiableList(this.workflowTemplates);
    }

    public boolean hasWorkflow(String workflowKey) {
        for (WorkflowTemplate workflowTemplate : this.workflowTemplates) {
            if (!workflowTemplate.key().equalsIgnoreCase(workflowKey)) continue;
            return true;
        }
        return false;
    }

    private void validate() {
        this.validateDefaultWorkflow();
    }

    private void validateDefaultWorkflow() {
        if (this.defaultWorkflow.isPresent() && !this.hasWorkflow(this.defaultWorkflow.get())) {
            throw new IllegalArgumentException("Default workflow '" + this.defaultWorkflow.get() + "' of workflow scheme '" + this.name + "' does not exist.");
        }
    }
}

