/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SimpleIssueFieldSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class CurrentReporterHasCreatePermission
extends SimpleIssueFieldSecurityType {
    private JiraAuthenticationContext jiraAuthenticationContext;
    private ProjectFactory projectFactory;

    public CurrentReporterHasCreatePermission(JiraAuthenticationContext jiraAuthenticationContext, ProjectFactory projectFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectFactory = projectFactory;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.current.reporter.has.create.perm");
    }

    @Override
    public String getType() {
        return "reportercreate";
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    public boolean isValidForPermission(ProjectPermissionKey permissionKey) {
        return !ProjectPermissions.CREATE_ISSUES.equals((Object)permissionKey);
    }

    @Override
    protected String getFieldName(String parameter) {
        return "issue_author";
    }

    @Override
    protected boolean hasProjectPermission(ApplicationUser user, boolean issueCreation, Project project) {
        return this.getPermissionManager().hasPermission(ProjectPermissions.CREATE_ISSUES, project, user, issueCreation);
    }

    @VisibleForTesting
    PermissionManager getPermissionManager() {
        return ComponentAccessor.getPermissionManager();
    }

    @Override
    protected String getField() {
        return "reporter";
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String ignored) {
        Issue issue = ctx.getIssue();
        if (issue != null && issue.getReporter() != null && this.getPermissionManager().hasPermission(11, issue.getReporter())) {
            return Sets.newHashSet((Object[])new ApplicationUser[]{issue.getReporter()});
        }
        return Sets.newHashSet();
    }

    @Override
    protected String getFieldValue(Issue issue) {
        return issue.getReporterId();
    }
}

