/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionReindexer;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;

public class DefaultShareManager
implements ShareManager {
    private final SharePermissionStore store;
    private final ShareTypeFactory shareTypeFactory;
    private final SharePermissionReindexer reindexer;

    public DefaultShareManager(SharePermissionStore store, ShareTypeFactory shareTypeFactory, SharePermissionReindexer reindexer) {
        Assertions.notNull((String)"Can not instantiate a ShareManager with a 'null' SharePermissionStore", (Object)store);
        Assertions.notNull((String)"Can not instantiate a ShareManager with a 'null' ShareTypeFactory", (Object)shareTypeFactory);
        Assertions.notNull((String)"Can not instantiate a ShareManager with a 'null' SharePermissionReindexer", (Object)reindexer);
        this.store = store;
        this.shareTypeFactory = shareTypeFactory;
        this.reindexer = reindexer;
    }

    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        return this.store.getSharePermissions(entity);
    }

    public void deletePermissions(SharedEntity entity) {
        this.store.deleteSharePermissions(entity);
    }

    public void deleteSharePermissionsLike(SharePermission permission) {
        this.store.deleteSharePermissionsLike(permission);
        this.reindexer.reindex(permission);
    }

    public SharedEntity.SharePermissions updateSharePermissions(SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity.sharePermissions", (Object)entity.getPermissions());
        if (entity.getPermissions().isPrivate()) {
            this.store.deleteSharePermissions(entity);
            return SharedEntity.SharePermissions.PRIVATE;
        }
        return this.store.storeSharePermissions(entity);
    }

    @Deprecated
    public boolean hasPermission(ApplicationUser user, SharedEntity entity) {
        return this.isSharedWith(user, entity);
    }

    public boolean isSharedWith(ApplicationUser user, SharedEntity sharedEntity) {
        Assertions.notNull((String)"entity", (Object)sharedEntity);
        if (sharedEntity.getOwner() != null ? sharedEntity.getOwner().equals((Object)user) : user == null) {
            return true;
        }
        SharedEntity.SharePermissions permissions = this.store.getSharePermissions(sharedEntity);
        if (permissions != null) {
            for (SharePermission sharePermission : permissions) {
                ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
                if (type == null || !type.getPermissionsChecker().hasPermission(user, sharePermission)) continue;
                return true;
            }
        }
        return false;
    }
}

