/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.PrivateShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class PrivateShareQueryFactory
implements ShareQueryFactory<PrivateShareTypeSearchParameter> {
    public Field getField(SharedEntity entity, SharePermission permission) {
        Assertions.not((String)"entity must be private", (!entity.getPermissions().isPrivate() ? 1 : 0) != 0);
        String ownerUserKey = entity.getOwner() == null ? null : entity.getOwner().getKey();
        return new Field("owner", ownerUserKey == null ? "" : ownerUserKey, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    public Term[] getTerms(ApplicationUser user) {
        Term[] termArray;
        Term term = this.getTerm(user);
        if (term == null) {
            termArray = new Term[]{};
        } else {
            Term[] termArray2 = new Term[1];
            termArray = termArray2;
            termArray2[0] = term;
        }
        return termArray;
    }

    public Query getQuery(ShareTypeSearchParameter parameter, ApplicationUser user) {
        Term term = this.getTerm(user);
        return term == null ? null : new TermQuery(term);
    }

    public Query getQuery(ShareTypeSearchParameter parameter) {
        throw new UnsupportedOperationException("Can't query for Private Shares");
    }

    private Term getTerm(ApplicationUser user) {
        return user == null ? null : new Term("owner", user.getKey());
    }

    private static final class Name {
        static final String FIELD = "owner";

        private Name() {
        }
    }
}

