/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.ProjectShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ProjectSharePermission;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectShareQueryFactory
implements ShareQueryFactory<ProjectShareTypeSearchParameter> {
    private static final Logger log = LoggerFactory.getLogger(ProjectShareQueryFactory.class);
    private final Visibility visibility;

    public ProjectShareQueryFactory(ProjectManager projectManager, ProjectRoleManager projectRoleManager, PermissionManager permissionManager, ProjectFactory projectFactory, RoleActorFactory roleActorFactory) {
        this(new VisibilityImpl(projectManager, projectRoleManager, permissionManager, projectFactory, roleActorFactory));
    }

    public ProjectShareQueryFactory(Visibility visibility) {
        this.visibility = visibility;
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter, ApplicationUser user) {
        ProjectShareTypeSearchParameter projectParameter = (ProjectShareTypeSearchParameter)searchParameter;
        this.visibility.check(user, projectParameter);
        TermQuery projectQuery = new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)projectParameter.getRoleId())));
        if (projectParameter.hasRole()) {
            return projectQuery;
        }
        BooleanQuery result = new BooleanQuery();
        result.add((Query)projectQuery, BooleanClause.Occur.SHOULD);
        for (ProjectRole role : this.visibility.getRoles(user, projectParameter.getProjectId())) {
            result.add((Query)new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)role.getId()))), BooleanClause.Occur.SHOULD);
        }
        return result;
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter) {
        ProjectShareTypeSearchParameter projectParameter = (ProjectShareTypeSearchParameter)searchParameter;
        TermQuery projectQuery = new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)projectParameter.getRoleId())));
        if (projectParameter.hasRole()) {
            return projectQuery;
        }
        BooleanQuery result = new BooleanQuery();
        result.add((Query)projectQuery, BooleanClause.Occur.SHOULD);
        result.add((Query)new PrefixQuery(new Term("shareTypeProject", ProjectSharePermission.searchAllRolesValue((Long)projectParameter.getProjectId()))), BooleanClause.Occur.SHOULD);
        return result;
    }

    public Term[] getTerms(ApplicationUser user) {
        List<ProjectAndRole> projectsAndRoles = this.visibility.getProjects(user);
        ArrayList<Term> result = new ArrayList<Term>(projectsAndRoles.size());
        for (ProjectAndRole projectAndRole : projectsAndRoles) {
            result.add(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectAndRole.getProjectId(), (Long)projectAndRole.getRoleId())));
        }
        return result.toArray(new Term[result.size()]);
    }

    public Field getField(SharedEntity entity, SharePermission permission) {
        return new Field("shareTypeProject", new ProjectSharePermission(permission).getIndexValue(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    static class ProjectAndRole {
        private final Long projectId;
        private final Long projectRoleId;

        public ProjectAndRole(Long projectId) {
            this(projectId, null);
        }

        public ProjectAndRole(Long projectId, Long projectRoleId) {
            Assertions.notNull((String)"projectId", (Object)projectId);
            this.projectId = projectId;
            this.projectRoleId = projectRoleId;
        }

        Long getProjectId() {
            return this.projectId;
        }

        Long getRoleId() {
            return this.projectRoleId;
        }
    }

    static class VisibilityImpl
    implements Visibility {
        private final ProjectManager projectManager;
        private final ProjectRoleManager projectRoleManager;
        private final PermissionManager permissionManager;
        private final ProjectFactory projectFactory;
        private final RoleActorFactory roleActorFactory;

        VisibilityImpl(ProjectManager projectManager, ProjectRoleManager projectRoleManager, PermissionManager permissionManager, ProjectFactory projectFactory, RoleActorFactory roleActorFactory) {
            Assertions.notNull((String)"projectManager", (Object)projectManager);
            Assertions.notNull((String)"projectRoleManager", (Object)projectRoleManager);
            Assertions.notNull((String)"permissionManager", (Object)permissionManager);
            Assertions.notNull((String)"projectFactory", (Object)projectFactory);
            this.projectManager = projectManager;
            this.projectRoleManager = projectRoleManager;
            this.permissionManager = permissionManager;
            this.projectFactory = projectFactory;
            this.roleActorFactory = roleActorFactory;
        }

        @Override
        public void check(ApplicationUser user, ProjectShareTypeSearchParameter projectParameter) {
            ProjectRole role;
            Project project = this.projectManager.getProjectObj(projectParameter.getProjectId());
            if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)) {
                throw new IllegalStateException("Cannot search for a Project you cannot see: " + project);
            }
            Long roleId = projectParameter.getRoleId();
            if (roleId != null && !this.projectRoleManager.isUserInProjectRole(user, role = this.projectRoleManager.getProjectRole(roleId), project)) {
                throw new IllegalStateException("Cannot search for a ProjectRole you not a member of: " + role + " project:" + project);
            }
        }

        @Override
        public List<ProjectAndRole> getProjects(final ApplicationUser user) {
            List projects = this.projectManager.getProjectObjects();
            ImmutableList.Builder resultsBuilder = ImmutableList.builder();
            Set allRoleActorsForUser = this.roleActorFactory.getAllRoleActorsForUser(user);
            resultsBuilder.addAll(Iterables.transform((Iterable)allRoleActorsForUser, (Function)new Function<ProjectRoleActor, ProjectAndRole>(){

                public ProjectAndRole apply(ProjectRoleActor simpleRoleActor) {
                    return new ProjectAndRole(simpleRoleActor.getProjectId(), simpleRoleActor.getProjectRoleId());
                }
            }));
            for (Project project : CollectionUtil.filter((Collection)projects, (Predicate)new Predicate<Project>(){

                public boolean evaluate(Project o) {
                    return permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, o, user);
                }
            })) {
                resultsBuilder.add((Object)new ProjectAndRole(project.getId()));
            }
            return resultsBuilder.build();
        }

        @Override
        public List<ProjectRole> getRoles(ApplicationUser user, Long projectId) {
            Project project = this.projectManager.getProjectObj(projectId);
            return Collections.unmodifiableList(new ArrayList(this.projectRoleManager.getProjectRoles(user, project)));
        }
    }

    static interface Visibility {
        public void check(ApplicationUser var1, ProjectShareTypeSearchParameter var2) throws IllegalStateException;

        public List<ProjectAndRole> getProjects(ApplicationUser var1);

        public List<ProjectRole> getRoles(ApplicationUser var1, Long var2);
    }

    private static final class Name {
        static final String FIELD = "shareTypeProject";

        private Name() {
        }
    }
}

