/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.appconsistency.clustering.ClusterLicenseStartupCheck;
import com.atlassian.jira.appconsistency.clustering.NodeIdCheck;
import com.atlassian.jira.appconsistency.clustering.SharedHomeCheck;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClusteringConfigChecklist {
    private static final Logger log = LoggerFactory.getLogger(JiraClusteringConfigChecklist.class);
    private final JiraStartupLogger startupLogger = new JiraStartupLogger();
    private final ClusterNodeProperties clusterNodeProperties;
    private final List<StartupCheck> checklist = new ArrayList<StartupCheck>();
    private final List<StartupCheck> failedStartupChecks = new ArrayList<StartupCheck>();
    private volatile boolean checksDone;
    private volatile boolean success;

    public JiraClusteringConfigChecklist(ClusterLicenseStartupCheck licenseCheck, ClusterNodeProperties clusterNodeProperties, I18nHelper i18nHelper, JiraHome jiraHome, ApplicationProperties applicationProperties) {
        this.clusterNodeProperties = clusterNodeProperties;
        this.checklist.add(new SharedHomeCheck(clusterNodeProperties, i18nHelper, jiraHome));
        this.checklist.add(new NodeIdCheck(clusterNodeProperties, i18nHelper));
        if ("true".equals(applicationProperties.getString("jira.setup"))) {
            this.checklist.add(licenseCheck);
        }
    }

    public boolean startupOK() {
        if (!this.checksDone) {
            this.success = true;
            if (this.clusterNodeProperties.propertyFileExists()) {
                log.debug("Performing Clustering start up checks");
                this.success = this.doStartupChecks();
                this.checksDone = true;
            }
        }
        return this.success;
    }

    private boolean doStartupChecks() {
        boolean success = true;
        log.debug("Doing clustering config checklist");
        for (StartupCheck startupCheck : this.checklist) {
            log.debug("Doing startup check " + startupCheck.getName());
            if (startupCheck.isOk()) continue;
            this.startupLogger.printMessage(startupCheck.getFaultDescription(), Level.FATAL);
            this.failedStartupChecks.add(startupCheck);
            success = false;
        }
        return success;
    }

    public List<StartupCheck> getFailedStartupChecks() {
        return this.failedStartupChecks;
    }
}

