/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.web.monitor.dump.ThreadInfos;
import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadDumper
implements Runnable {
    private static final Logger classLogger = LoggerFactory.getLogger(ThreadDumper.class);
    private final Logger log;
    private final AtomicBoolean shouldLog = new AtomicBoolean(true);
    private final long timeout;

    public ThreadDumper(long timeout) {
        this(timeout, classLogger);
    }

    @VisibleForTesting
    ThreadDumper(long timeout, Logger log) {
        this.timeout = timeout < 1L ? 1L : timeout;
        this.log = log;
    }

    public synchronized void cancelDump() {
        this.shouldLog.set(false);
        this.notify();
    }

    @Override
    public synchronized void run() {
        if (!this.shouldLog.get()) {
            this.log.debug("Thread logging set to do-not-log. Exiting early.");
            return;
        }
        try {
            long start = System.currentTimeMillis();
            long elapsed = 0L;
            while (elapsed < this.timeout && !this.interrupted() && this.shouldLog.get()) {
                this.wait(this.timeout - elapsed);
                elapsed = System.currentTimeMillis() - start;
            }
        }
        catch (InterruptedException e) {
            this.log.error("Thread logging thread interrupted. Will log threads immediately.", (Throwable)e);
        }
        this.logThreads();
    }

    private boolean interrupted() {
        Thread thread = Thread.currentThread();
        return thread.isInterrupted();
    }

    private void logThreads() {
        if (!this.shouldLog.get()) {
            this.log.info("Thread logging requested and JIRA shutdown completed within specified timeout " + this.timeout + "ms. Hooray!");
            return;
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported());
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        printWriter.printf("Logging all threads because time limit for shutdown was reached: %d.", this.timeout);
        printWriter.println();
        for (ThreadInfo thread : threadInfos) {
            printWriter.append(ThreadInfos.toString(thread));
        }
        this.log.error(out.toString());
    }

    public boolean isLogEnabled() {
        return this.shouldLog.get();
    }

    public long getTimeout() {
        return this.timeout;
    }
}

