/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.upgrade.tasks.AbstractReindexUpgradeTask;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build663
extends AbstractReindexUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build663.class);

    @Override
    public String getBuildNumber() {
        return "663";
    }

    @Override
    public String getShortDescription() {
        return "Detect and repair duplicate keys in JIRA table";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Connection connection = this.getDatabaseConnection();
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            Map<String, Set<String>> duplicateKeys = this.checkDuplicatesExist(connection, "jiraissue");
            if (duplicateKeys.size() > 0) {
                this.patchIssues(connection, duplicateKeys);
            }
            connection.commit();
            committed = true;
            if (duplicateKeys.size() > 0) {
                this.getReindexRequestService().requestReindex(ReindexRequestType.IMMEDIATE, EnumSet.of(AffectedIndex.ISSUE), EnumSet.noneOf(SharedEntityType.class));
            }
        }
        finally {
            if (!committed) {
                connection.rollback();
            }
            connection.close();
        }
    }

    private Map<String, Set<String>> checkDuplicatesExist(Connection connection, String tableName) throws SQLException {
        HashMap duplicateKeys = Maps.newHashMap();
        String sql = "select pkey from " + this.convertToSchemaTableName(tableName) + " group by pkey having count(pkey) > 1";
        Statement select = connection.createStatement();
        ResultSet rs = select.executeQuery(sql);
        while (rs.next()) {
            String issueKey = rs.getString(1);
            String projectKey = this.extractProjectKey(issueKey);
            if (duplicateKeys.containsKey(projectKey)) {
                ((Set)duplicateKeys.get(projectKey)).add(issueKey);
                continue;
            }
            HashSet issueKeys = Sets.newHashSet();
            issueKeys.add(issueKey);
            duplicateKeys.put(projectKey, issueKeys);
        }
        rs.close();
        select.close();
        return duplicateKeys;
    }

    private void patchIssues(Connection connection, Map<String, Set<String>> duplicateKeys) throws SQLException {
        String jiraIssueTable = this.convertToSchemaTableName("jiraissue");
        String selectSql = "select pcounter from " + this.convertToSchemaTableName("project") + " where pkey=?";
        String selectSql2 = "select pkey from " + jiraIssueTable + " where id=(select max(id) from " + jiraIssueTable + " where pkey like ?)";
        String selectSql3 = "select id from " + jiraIssueTable + " where pkey=?";
        PreparedStatement selectStmt = connection.prepareStatement(selectSql);
        PreparedStatement selectStmt2 = connection.prepareStatement(selectSql2);
        PreparedStatement selectStmt3 = connection.prepareStatement(selectSql3);
        for (String pKey : duplicateKeys.keySet()) {
            ResultSet issueKeyCounterResultSet;
            int maxCountFromProjectTable = 0;
            int maxCountFromIssueTable = 0;
            int safeProjectCounter = 0;
            selectStmt.setString(1, pKey);
            selectStmt2.setString(1, this.makeLikePatternForKey(pKey));
            ResultSet projectCounterResultSet = selectStmt.executeQuery();
            if (projectCounterResultSet.next()) {
                maxCountFromProjectTable = projectCounterResultSet.getInt(1);
            }
            if ((issueKeyCounterResultSet = selectStmt2.executeQuery()).next()) {
                maxCountFromIssueTable = this.parseIssueKey(issueKeyCounterResultSet.getString(1));
            }
            safeProjectCounter = maxCountFromProjectTable > maxCountFromIssueTable ? maxCountFromProjectTable : maxCountFromIssueTable;
            for (String issueKey : duplicateKeys.get(pKey)) {
                HashSet ids = Sets.newHashSet();
                selectStmt3.setString(1, issueKey);
                ResultSet idsResultSet = selectStmt3.executeQuery();
                while (idsResultSet.next()) {
                    ids.add(idsResultSet.getLong(1));
                }
                safeProjectCounter = this.fixDuplicates(connection, pKey, ids, safeProjectCounter);
            }
            this.updateProjectCounter(connection, pKey, safeProjectCounter);
        }
        selectStmt.close();
        selectStmt2.close();
        selectStmt3.close();
    }

    private void updateProjectCounter(Connection connection, String pKey, int safeProjectCounter) throws SQLException {
        String updateSql = "update " + this.convertToSchemaTableName("project") + " set pcounter = ? where pkey = ? ";
        PreparedStatement updateStmt = connection.prepareStatement(updateSql);
        updateStmt.setInt(1, safeProjectCounter);
        updateStmt.setString(2, pKey);
        updateStmt.executeUpdate();
        updateStmt.close();
    }

    private int fixDuplicates(Connection connection, String pKey, Set<Long> ids, int safeProjectCounter) throws SQLException {
        String updateSql = "update " + this.convertToSchemaTableName("jiraissue") + " set pkey = ? where id = ? ";
        PreparedStatement updateStmt = connection.prepareStatement(updateSql);
        Iterator<Long> iter = ids.iterator();
        iter.next();
        while (iter.hasNext()) {
            String issueKey = pKey + "-" + ++safeProjectCounter;
            Long id = iter.next();
            updateStmt.setString(1, issueKey);
            updateStmt.setLong(2, id);
            updateStmt.executeUpdate();
            log.info(String.format("Found issue id %d with duplicate key: Replacing with %s", id, issueKey));
            updateStmt.close();
        }
        return safeProjectCounter;
    }

    private int parseIssueKey(String pKey) {
        int index = pKey.indexOf("-");
        if (index >= 0) {
            return Integer.parseInt(pKey.substring(index + 1));
        }
        return 0;
    }

    private String makeLikePatternForKey(String pKey) {
        return this.extractProjectKey(pKey) + "-%";
    }

    private String extractProjectKey(String pKey) {
        int index = pKey.indexOf("-");
        if (index >= 0) {
            return pKey.substring(0, index);
        }
        return pKey;
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "645";
    }
}

