/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.OfBizUserHistoryStore;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingUserHistoryStore
implements UserHistoryStore {
    static final int DEFAULT_MAX_ITEMS = 20;
    private static final int DEFAULT_MAX_THRESHOLD = 10;
    private static final int LAZY_WRITE_BACK_QUEUE_LIMIT = 1024;
    private static final int LAZY_WRITE_BACK_MAX_WORKERS = 8;
    private static final Logger log = LoggerFactory.getLogger(CachingUserHistoryStore.class);
    private final Cache<Key, List<UserHistoryItem>> cache;
    private final AtomicReference<ExecutorService> executor = new AtomicReference();
    @ClusterSafe(value="A given user should only be using one node at a time, even if logged into multiple")
    private final Function<ApplicationUser, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory(ApplicationUser::getKey);
    private final OfBizUserHistoryStore delegatingStore;
    private final ApplicationProperties applicationProperties;
    private final int maxThreshold;

    public CachingUserHistoryStore(@Nonnull OfBizUserHistoryStore delegatingStore, @Nonnull ApplicationProperties applicationProperties, @Nonnull CacheManager cacheManager) {
        this(delegatingStore, applicationProperties, cacheManager, 10);
    }

    CachingUserHistoryStore(@Nonnull OfBizUserHistoryStore delegatingStore, @Nonnull ApplicationProperties applicationProperties, CacheManager cacheManager, int maxThreshold) {
        this.delegatingStore = (OfBizUserHistoryStore)Assertions.notNull((String)"delegatingStore", (Object)delegatingStore);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.maxThreshold = maxThreshold;
        this.cache = cacheManager.getCache(CachingUserHistoryStore.class.getName() + ".cache", (CacheLoader)new DelegatingStoreCacheLoader(), new CacheSettingsBuilder().local().expireAfterAccess(15L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onComponentManagerStarted(ComponentManagerStartedEvent startedEvent) {
        ThreadPoolExecutor e = new ThreadPoolExecutor(0, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), ThreadFactories.namedThreadFactory("UserHistoryWriter"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.executor.set(e);
    }

    @EventListener
    public void onComponentManagerShutdown(ComponentManagerShutdownEvent shutdownEvent) {
        ExecutorService e = this.executor.getAndSet(null);
        if (e != null) {
            e.shutdown();
            try {
                e.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                e.shutdownNow();
            }
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    @Override
    public void addHistoryItem(final ApplicationUser user, final @Nonnull UserHistoryItem historyItem) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)historyItem);
        AddHistoryResult result = (AddHistoryResult)((ManagedLock)this.lockManager.get((Object)user)).withLock((Supplier)new Supplier<AddHistoryResult>(){

            public AddHistoryResult get() {
                return CachingUserHistoryStore.this.addCachedHistoryItem(user, historyItem);
            }
        });
        this.executor.get().submit(new UserHistoryWriter(result, user, historyItem));
    }

    @GuardedBy(value="lockManager.get(user)")
    AddHistoryResult addCachedHistoryItem(@Nonnull ApplicationUser user, @Nonnull UserHistoryItem historyItem) {
        UserHistoryItem.Type type = historyItem.getType();
        List history = (List)this.cache.get((Object)new Key(user.getKey(), type));
        if (this.removeCachedHistoryItem(history, historyItem)) {
            history.add(0, historyItem);
            return AddHistoryResult.SIMPLE_UPDATE;
        }
        history.add(0, historyItem);
        int maxItems = CachingUserHistoryStore.getMaxItems(historyItem.getType(), this.applicationProperties);
        if (history.size() <= maxItems + this.maxThreshold) {
            return AddHistoryResult.SIMPLE_CREATE;
        }
        ArrayList entitiesToDelete = Lists.newArrayList();
        while (history.size() > maxItems) {
            UserHistoryItem item = (UserHistoryItem)history.remove(maxItems);
            entitiesToDelete.add(item.getEntityId());
        }
        return new AddHistoryResult(entitiesToDelete);
    }

    @GuardedBy(value="lockManager.get(user)")
    private boolean removeCachedHistoryItem(@Nonnull Iterable<UserHistoryItem> history, @Nonnull UserHistoryItem historyItem) {
        Iterator<UserHistoryItem> iter = history.iterator();
        while (iter.hasNext()) {
            UserHistoryItem currentHistoryItem = iter.next();
            if (!currentHistoryItem.getEntityId().equals(historyItem.getEntityId())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public List<UserHistoryItem> getHistory(@Nonnull UserHistoryItem.Type type, @Nonnull String userKey) {
        Assertions.notNull((String)"userKey", (Object)userKey);
        Assertions.notNull((String)"type", (Object)type);
        try {
            return ImmutableList.copyOf((Collection)((Collection)this.cache.get((Object)new Key(userKey, type))));
        }
        catch (CacheException e) {
            if (e.getCause() instanceof DataAccessException) {
                log.debug("Unable to get user history items. Returning empty list.", (Throwable)e);
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    @Nonnull
    public List<UserHistoryItem> getHistory(@Nonnull UserHistoryItem.Type type, @Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.getHistory(type, user.getKey());
    }

    @Override
    public Set<UserHistoryItem.Type> removeHistoryForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        Set<UserHistoryItem.Type> typesRemoved = this.delegatingStore.removeHistoryForUser(user);
        for (UserHistoryItem.Type type : typesRemoved) {
            this.flushCache(type, user);
        }
        return typesRemoved;
    }

    @Override
    public void removeHistoryOlderThan(@Nonnull Long timestamp) {
        Assertions.notNull((String)"timestamp", (Object)timestamp);
        this.delegatingStore.removeHistoryOlderThan(timestamp);
        this.cache.removeAll();
    }

    private void flushCache(UserHistoryItem.Type type, ApplicationUser user) {
        this.cache.remove((Object)new Key(user.getKey(), type));
    }

    public static int getMaxItems(UserHistoryItem.Type type, ApplicationProperties applicationProperties) {
        String maxItemsForTypeStr = applicationProperties.getDefaultBackedString("jira.max." + type.getName() + ".history.items");
        int maxItems = 20;
        try {
            if (StringUtils.isNotBlank((String)maxItemsForTypeStr)) {
                return Integer.parseInt(maxItemsForTypeStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Incorrect format of property 'jira.max." + type.getName() + ".history.items'.  Should be a number.");
        }
        String maxItemsStr = applicationProperties.getDefaultBackedString("jira.max.history.items");
        try {
            if (StringUtils.isNotBlank((String)maxItemsStr)) {
                return Integer.parseInt(maxItemsStr);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Incorrect format of property 'jira.max.history.items'.  Should be a number.");
        }
        return 20;
    }

    private class UserHistoryWriter
    implements Runnable {
        private final AddHistoryResult result;
        private final ApplicationUser user;
        private final UserHistoryItem historyItem;

        public UserHistoryWriter(AddHistoryResult result, ApplicationUser user, UserHistoryItem historyItem) {
            this.result = result;
            this.user = user;
            this.historyItem = historyItem;
        }

        @Override
        public void run() {
            block7: {
                try {
                    if (this.result.create) {
                        try {
                            CachingUserHistoryStore.this.delegatingStore.addHistoryItemNoChecks(this.user, this.historyItem);
                            if (this.result.toDelete != null) {
                                CachingUserHistoryStore.this.delegatingStore.expireOldHistoryItems(this.user, this.historyItem.getType(), this.result.toDelete);
                            }
                            break block7;
                        }
                        catch (DataAccessException e) {
                            if (CachingUserHistoryStore.this.delegatingStore.removeHistoryItem(this.user, this.historyItem)) {
                                CachingUserHistoryStore.this.delegatingStore.addHistoryItemNoChecks(this.user, this.historyItem);
                                break block7;
                            }
                            throw e;
                        }
                    }
                    CachingUserHistoryStore.this.delegatingStore.updateHistoryItemNoChecks(this.user, this.historyItem);
                }
                catch (DataAccessException e) {
                    CachingUserHistoryStore.this.flushCache(this.historyItem.getType(), this.user);
                    log.debug("Unable to add user history to store. Ignoring error.", (Throwable)e);
                }
            }
        }
    }

    static class AddHistoryResult {
        static final AddHistoryResult SIMPLE_CREATE = new AddHistoryResult(true, null);
        static final AddHistoryResult SIMPLE_UPDATE = new AddHistoryResult(false, null);
        final boolean create;
        final List<String> toDelete;

        AddHistoryResult(List<String> toDelete) {
            this(true, toDelete);
        }

        private AddHistoryResult(boolean create, List<String> toDelete) {
            this.create = create;
            this.toDelete = toDelete;
        }
    }

    @VisibleForTesting
    static final class Key
    implements Serializable {
        private final String userKey;
        private final UserHistoryItem.Type type;

        public Key(String userKey, UserHistoryItem.Type type) {
            Assertions.notNull((String)"user", (Object)userKey);
            Assertions.notNull((String)"type", (Object)type);
            this.userKey = userKey;
            this.type = type;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public UserHistoryItem.Type getType() {
            return this.type;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return this.type.equals((Object)otherKey.type) && this.userKey.equals(otherKey.userKey);
        }

        public int hashCode() {
            return this.userKey.hashCode() * 31 + this.type.hashCode();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    final class DelegatingStoreCacheLoader
    implements CacheLoader<Key, List<UserHistoryItem>> {
        DelegatingStoreCacheLoader() {
        }

        public List<UserHistoryItem> load(Key key) {
            List<UserHistoryItem> history = CachingUserHistoryStore.this.delegatingStore.getHistory(key.type, key.userKey);
            return new ArrayList<UserHistoryItem>(history);
        }
    }
}

