/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserAdminHistoryManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class DefaultUserAdminHistoryManager
implements UserAdminHistoryManager {
    private final UserHistoryManager userHistoryManager;

    public DefaultUserAdminHistoryManager(UserHistoryManager userHistoryManager) {
        this.userHistoryManager = userHistoryManager;
    }

    public void addAdminPageToHistory(ApplicationUser user, String key, String data) {
        Assertions.notNull((String)"key", (Object)key);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.ADMIN_PAGE, user, key, data);
    }

    public List<UserHistoryItem> getAdminPageHistoryWithoutPermissionChecks(ApplicationUser user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.ADMIN_PAGE, user);
        if (history == null) {
            return Lists.newArrayList();
        }
        ArrayList<UserHistoryItem> returnList = new ArrayList<UserHistoryItem>(history.size());
        for (UserHistoryItem userHistoryItem : history) {
            String key = userHistoryItem.getEntityId();
            if (key == null) continue;
            returnList.add(userHistoryItem);
        }
        return returnList;
    }
}

