/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.atlassian.jira.logging.RollOverLogAppender;
import com.atlassian.jira.startup.FormattedLogMsg;
import java.io.File;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LogMarker {
    private static final Logger log = Logger.getLogger(LogMarker.class);

    public static void markLogs(String message) {
        FormattedLogMsg logMsg = new FormattedLogMsg(log);
        if (message != null && !message.isEmpty()) {
            logMsg.add(message);
        }
        logMsg.printMessage(Level.INFO, true);
    }

    public static void rolloverAndMark(String message) {
        LogMarker.markLogs("");
        LogMarker.rollover(log);
        LogMarker.markLogs(message);
    }

    public static void rollover(Logger log) {
        Logger logger;
        for (logger = log; logger != null && !logger.getAllAppenders().hasMoreElements(); logger = (Logger)logger.getParent()) {
        }
        if (logger == null) {
            return;
        }
        Enumeration enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            if (!(appender instanceof RollOverLogAppender)) continue;
            LogMarker.rolloverAsAppropropriate((RollOverLogAppender)appender);
        }
    }

    private static void rolloverAsAppropropriate(RollOverLogAppender rollOverLogAppender) {
        File logFile = new File(rollOverLogAppender.getFile());
        if (logFile.exists() && logFile.length() > 0L) {
            rollOverLogAppender.rollOver();
        }
    }
}

