/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.PluggableTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.plugin.PluginAccessor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import webwork.action.ActionContext;

public abstract class AbstractPluggableTabPanelAction<TabPanelClass extends PluggableTabPanelModuleDescriptor>
extends IssueActionSupport {
    protected final PluginAccessor pluginAccessor;
    private List<TabPanelClass> tabPanels;
    private String persistenceKey;

    public AbstractPluggableTabPanelAction(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.persistenceKey = AbstractPluggableTabPanelAction.class.toString();
    }

    public List<TabPanelClass> getTabPanels() {
        if (this.tabPanels == null) {
            this.tabPanels = this.initTabPanels();
        }
        return this.tabPanels;
    }

    protected List<TabPanelClass> initTabPanels() {
        List<TabPanelClass> tabPanels = this.getTabPanelModuleDescriptors();
        return tabPanels.stream().filter(this::isVisible).sorted((Comparator<PluggableTabPanelModuleDescriptor>)ModuleDescriptorComparator.COMPARATOR).collect(Collectors.toList());
    }

    protected abstract List<TabPanelClass> getTabPanelModuleDescriptors();

    protected abstract boolean isTabPanelHidden(TabPanelClass var1) throws PermissionException;

    protected boolean canSeeTab(String tabKey) {
        if (tabKey == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(tabKey, ":");
        if (tokenizer.countTokens() == 2) {
            tokenizer.nextToken();
            String tabName = tokenizer.nextToken();
            return this.getTabPanels().stream().anyMatch(tabPanel -> tabPanel.getKey().equals(tabName));
        }
        return false;
    }

    public TabPanelClass getSelectedTabPanel() {
        return (TabPanelClass)((PluggableTabPanelModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(this.getSelectedTab()));
    }

    public String getSelected() {
        return this.getSelectedTab();
    }

    protected String getSelectedTab() {
        String currentKey = (String)this.getSession().get(this.persistenceKey);
        if (this.canSeeTab(currentKey)) {
            return currentKey;
        }
        List<TabPanelClass> projectTabPanels = this.getTabPanels();
        if (!projectTabPanels.isEmpty()) {
            String key = ((PluggableTabPanelModuleDescriptor)projectTabPanels.get(0)).getCompleteKey();
            this.setSelectedTab(key);
            return key;
        }
        return null;
    }

    public void setSelectedTab(String selectedTab) {
        this.getSession().put(this.persistenceKey, selectedTab);
    }

    private Map<String, Object> getSession() {
        return ActionContext.getSession();
    }

    public void setPersistenceKey(@Nonnull String persistenceKey) {
        this.persistenceKey = persistenceKey;
    }

    private boolean isVisible(TabPanelClass tabPanelClass) {
        try {
            return tabPanelClass != null && !this.isTabPanelHidden(tabPanelClass);
        }
        catch (PermissionException e) {
            return false;
        }
    }
}

