/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.LocalDashboardItemModuleId;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardService;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.DashboardTab;
import com.atlassian.gadgets.dashboard.PermissionException;
import com.atlassian.gadgets.dashboard.view.DashboardTabViewFactory;
import com.atlassian.gadgets.view.ViewComponent;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.security.login.LoginProperties;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.dashboard.analytics.DashboardViewAnalyticsEvent;
import com.atlassian.jira.dashboard.permission.GadgetPermissionManager;
import com.atlassian.jira.dashboard.permission.JiraPermissionService;
import com.atlassian.jira.event.DashboardViewEvent;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.Renderable;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.setup.SetupImport;
import com.atlassian.jira.web.landingpage.LandingPageRedirectManager;
import com.atlassian.jira.web.pagebuilder.GeneralJspDecorator;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class Dashboard
extends JiraWebActionSupport {
    private static final String LOGIN_DASHBOARD_ITEM_KEY = "com.atlassian.jira.gadgets:login-dashboard-item";
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final DashboardTabViewFactory dashboardTabViewFactory;
    private final DashboardService dashboardService;
    private final PortalPageService portalPageService;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final GadgetPermissionManager gadgetPermissionManager;
    private final LoginService loginService;
    private final UserHistoryManager userHistoryManager;
    private final EventPublisher eventPublisher;
    private final JiraPageBuilderService jiraPageBuilderService;
    private final FeatureManager featureManager;
    private final LandingPageRedirectManager landingPageRedirectManager;
    private Long currentDashboardId;
    private List<DashboardTab> dashboardTabs;
    private List<DashboardTab> userTabs;
    private DashboardState currentDashboardState;
    private Boolean currentUserOwnPages;
    private Long selectPageId;
    private String infoMessage = null;
    private String installationSource = null;

    public void setSrc(String src) {
        this.installationSource = src;
    }

    public Dashboard(PortalPageService portalPageService, ApplicationProperties applicationProperties, GadgetPermissionManager gadgetPermissionManager, LoginService loginService, UserHistoryManager userHistoryManager, EventPublisher eventPublisher, JiraPageBuilderService jiraPageBuilderService, FeatureManager featureManager, XsrfTokenGenerator xsrfTokenGenerator, LandingPageRedirectManager landingPageRedirectManager) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.applicationProperties = applicationProperties;
        this.gadgetPermissionManager = gadgetPermissionManager;
        this.loginService = loginService;
        this.userHistoryManager = userHistoryManager;
        this.eventPublisher = eventPublisher;
        this.portalPageService = portalPageService;
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.featureManager = featureManager;
        this.dashboardTabViewFactory = (DashboardTabViewFactory)ComponentAccessor.getOSGiComponentInstanceOfType(DashboardTabViewFactory.class);
        this.dashboardService = (DashboardService)ComponentAccessor.getOSGiComponentInstanceOfType(DashboardService.class);
        this.gadgetRequestContextFactory = (GadgetRequestContextFactory)ComponentAccessor.getOSGiComponentInstanceOfType(GadgetRequestContextFactory.class);
        this.landingPageRedirectManager = landingPageRedirectManager;
    }

    protected void doValidation() {
        if (!this.isDashboardPluginEnabled()) {
            String link = this.getAdministratorContactLink();
            this.addErrorMessage(this.getText("admin.errors.portalpages.plugin.disabled", link));
            return;
        }
        try {
            JiraPermissionService.setAllowEditingOfDefaultDashboard(false);
            this.getCurrentDashboardState();
        }
        catch (PermissionException e) {
            this.addErrorMessage(this.getText("admin.errors.portalpages.no.access"));
        }
    }

    protected String doExecute() throws Exception {
        Optional<String> redirectUrl;
        this.tagMauEventWithApplication(MauApplicationKey.family());
        if (this.selectPageId == null && (redirectUrl = this.landingPageRedirectManager.redirectUrl(this.getLoggedInUser())).isPresent()) {
            return this.getRedirect(redirectUrl.get());
        }
        if (!this.isDashboardPluginEnabled()) {
            return "error";
        }
        WebResourceAssembler assembler = this.jiraPageBuilderService.assembler();
        assembler.data().requireData("dashboardInfoMessage", this.getInfoMessage());
        assembler.data().requireData("dashboardInstallMessage", this.getInstallationMessage());
        assembler.resources().requireWebResource("com.atlassian.gadgets.dashboard:dashboard").requireWebResource("com.atlassian.gadgets.dashboard:gadget-dashboard-resources").requireContext("atl.dashboard").requireContext("jira.dashboard");
        if (!this.featureManager.isEnabled("com.atlassian.plugins.dashboard.SEND_HEAD_EARLY.disabled")) {
            this.jiraPageBuilderService.get().setDecorator(new GeneralJspDecorator(assembler));
            this.jiraPageBuilderService.get().flush();
        }
        if (ActionContext.getParameters().containsKey("resetPortal")) {
            this.userHistoryManager.addItemToHistory(UserHistoryItem.DASHBOARD, this.getLoggedInUser(), String.valueOf(this.getPageIdForUser()));
        }
        if (this.selectPageId != null && this.isFavouritePage(this.selectPageId)) {
            this.userHistoryManager.addItemToHistory(UserHistoryItem.DASHBOARD, this.getLoggedInUser(), String.valueOf(this.selectPageId));
        }
        this.eventPublisher.publish((Object)new DashboardViewEvent(this.currentDashboardId));
        return "success";
    }

    private boolean isDashboardPluginEnabled() {
        return this.dashboardTabViewFactory != null && this.dashboardService != null && this.gadgetRequestContextFactory != null;
    }

    public String getDashboardTitle() {
        return this.getCurrentDashboardState().getTitle();
    }

    public String getInstallationMessage() {
        if (this.installationSource != null) {
            return SetupImport.class.getSimpleName().equals(this.installationSource) ? this.getText("setup.complete.import.message") : this.getText("setup.complete.message");
        }
        return null;
    }

    public Renderable getDashboardRenderable() {
        GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(this.getHttpRequest());
        final ViewComponent view = this.dashboardTabViewFactory.createDashboardView(this.getDashboardTabs(), this.getCurrentDashboardState(), this.getUsername(), DashboardUtil.getMaxGadgets((ApplicationProperties)this.applicationProperties), requestContext);
        return new Renderable(){

            public void render(Writer writer) throws IOException {
                view.writeTo(writer);
            }
        };
    }

    public Long getCurrentDashboardId() {
        if (this.currentDashboardId == null) {
            this.initialiseCurrentDashboardId();
        }
        return this.currentDashboardId;
    }

    public DashboardState getCurrentDashboardState() throws PermissionException {
        if (this.currentDashboardState == null) {
            this.currentDashboardState = this.dashboardService.get(DashboardId.valueOf((String)this.getCurrentDashboardId().toString()), this.getUsername());
            if (this.getLoggedInUser() == null && this.isSystemDashboardId(this.getCurrentDashboardId()) && !this.applicationProperties.getOption("jira.disable.login.gadget")) {
                DashboardState.ColumnIndex rightColumn = DashboardState.ColumnIndex.from((int)(this.currentDashboardState.getLayout().getNumberOfColumns() - 1));
                Map<String, String> loginGadgetPrefs = this.buildLoginProperties();
                LocalDashboardItemState loginDashboardItemState = LocalDashboardItemState.builder().gadgetId(GadgetId.valueOf((String)Long.toString(0L))).properties(loginGadgetPrefs).color(Color.color1).dashboardItemModuleId(new LocalDashboardItemModuleId(new ModuleCompleteKey(LOGIN_DASHBOARD_ITEM_KEY))).build();
                this.currentDashboardState = this.currentDashboardState.prependItemToColumn((DashboardItemState)loginDashboardItemState, rightColumn);
            }
            DashboardState unfilteredDashboardState = this.currentDashboardState;
            this.currentDashboardState = this.gadgetPermissionManager.filterGadgets(this.currentDashboardState, this.getLoggedInUser());
            DashboardViewAnalyticsEvent analyticsEvent = this.generateDashboardAnalyticEvent(this.currentDashboardId, unfilteredDashboardState.getDashboardColumns().getColumns(), this.currentDashboardState.getDashboardColumns().getColumns());
            this.eventPublisher.publish((Object)analyticsEvent);
        }
        return this.currentDashboardState;
    }

    @VisibleForTesting
    DashboardViewAnalyticsEvent generateDashboardAnalyticEvent(Long dashboardId, List<List<DashboardItemState>> dashboardColumns, List<List<DashboardItemState>> filteredDashboardColumns) {
        long totalItems = this.countDashboardItemsInColumns(dashboardColumns);
        long itemsShown = this.countDashboardItemsInColumns(filteredDashboardColumns);
        long itemsHidden = totalItems - itemsShown;
        return new DashboardViewAnalyticsEvent(dashboardId, itemsShown, itemsHidden);
    }

    private long countDashboardItemsInColumns(List<List<DashboardItemState>> columns) {
        long count = 0L;
        for (List<DashboardItemState> column : columns) {
            count += (long)column.size();
        }
        return count;
    }

    private Map<String, String> buildLoginProperties() {
        LoginProperties loginProperties = this.loginService.getLoginProperties(this.getLoggedInUser(), this.getHttpRequest());
        return MapBuilder.newBuilder().add((Object)"loginSucceeded", (Object)String.valueOf(loginProperties.isLoginSucceeded())).add((Object)"allowCookies", (Object)String.valueOf(loginProperties.isAllowCookies())).add((Object)"externalUserManagement", (Object)String.valueOf(loginProperties.isExternalUserManagement())).add((Object)"isPublicMode", (Object)String.valueOf(loginProperties.isPublicMode())).add((Object)"isElevatedSecurityCheckShown", (Object)String.valueOf(loginProperties.isElevatedSecurityCheckShown())).add((Object)"captchaFailure", (Object)String.valueOf(loginProperties.isCaptchaFailure())).add((Object)"loginFailedByPermissions", (Object)String.valueOf(loginProperties.getLoginFailedByPermissions())).add((Object)"isAdminFormOn", (Object)String.valueOf(this.applicationProperties.getOption("jira.show.contact.administrators.form"))).toMap();
    }

    public Long getSelectPageId() {
        return this.selectPageId;
    }

    public void setSelectPageId(Long selectPageId) {
        this.selectPageId = selectPageId;
    }

    public String getLoginLink() {
        StringBuilder link = new StringBuilder();
        link.append("<a rel=\"nofollow\" href=\"");
        link.append(RedirectUtils.getLinkLoginURL((HttpServletRequest)this.request));
        link.append("\">");
        link.append(this.getText("login.required.login"));
        link.append("</a>");
        return this.getText("dashboard.page.login", link.toString());
    }

    private String getInfoMessage() {
        boolean currentPortalPageFavourite;
        PortalPage portalPage = this.portalPageService.getPortalPage(this.getJiraServiceContext(), this.currentDashboardId);
        if (portalPage == null) {
            return null;
        }
        if (this.infoMessage != null) {
            return this.infoMessage;
        }
        if (this.getLoggedInUser() == null) {
            this.infoMessage = this.isEmptyDashboard() ? this.getText("dashboard.no.gadget.permission.logged.out", String.format("<a rel=\"nofollow\" href=\"%s\">", RedirectUtils.getLinkLoginURL((HttpServletRequest)this.getHttpRequest())), "</a>") : "";
            return this.infoMessage;
        }
        String newWarningMessage = null;
        boolean hasPreferredPages = this.doesUserHavePreferredPages();
        if (!(this.selectPageId == null || (currentPortalPageFavourite = this.portalPageService.isFavourite(this.getLoggedInUser(), portalPage)) || !hasPreferredPages && portalPage.isSystemDefaultPortalPage())) {
            newWarningMessage = this.getText("dashboard.non.favourite.displayed", this.createFavouriteLink(portalPage), "</a>");
        }
        if (newWarningMessage == null && !hasPreferredPages && portalPage.isSystemDefaultPortalPage() && this.doesUserOwnPages()) {
            newWarningMessage = this.getText("dashboard.no.pages.to.display", this.createManageDashboardLinkShowMyTab(), "</a>");
        }
        if (newWarningMessage == null && !this.isUserCurrentPageOwner(portalPage) && this.isEmptyPortalPage(portalPage.getId()) && this.portalPageService.isFavourite(this.getLoggedInUser(), portalPage)) {
            newWarningMessage = this.getText("dashboard.no.portlet", this.createUnfavouriteLink(portalPage), "</a>");
        }
        if (newWarningMessage == null && this.isEmptyDashboard() && !this.isUserCurrentPageOwner(portalPage)) {
            String link = this.getAdministratorContactLink().replace("\"", "'");
            newWarningMessage = this.getText("dashboard.no.gadget.permission", link);
        }
        this.infoMessage = newWarningMessage == null ? "" : newWarningMessage;
        return this.infoMessage;
    }

    private boolean isEmptyPortalPage(Long portalPageId) {
        List list = this.portalPageService.getPortletConfigurations(this.getJiraServiceContext(), portalPageId);
        for (List portletConfigurations : list) {
            if (portletConfigurations.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyDashboard() {
        DashboardState state = this.getCurrentDashboardState();
        int gadgetCount = 0;
        for (Iterable column : state.getDashboardColumns().getColumns()) {
            gadgetCount += Iterables.size((Iterable)column);
        }
        return gadgetCount == 0;
    }

    private boolean isFavouritePage(Long pageId) {
        return this.portalPageService.isFavourite(this.getLoggedInUser(), this.portalPageService.getPortalPage(this.getJiraServiceContext(), pageId));
    }

    private List<DashboardTab> getDashboardTabs() {
        if (this.dashboardTabs == null) {
            ApplicationUser currentUser = this.getLoggedInUser();
            ArrayList<DashboardTab> ret = new ArrayList<DashboardTab>(this.getUserTabs());
            PortalPage page = this.portalPageService.getPortalPage(this.getJiraServiceContext(), this.getCurrentDashboardId());
            if (!this.portalPageService.isFavourite(currentUser, page)) {
                ret.add(this.createDashboardTab(page));
            }
            this.dashboardTabs = ret;
        }
        return this.dashboardTabs;
    }

    private boolean doesUserHavePreferredPages() {
        return !this.getUserTabs().isEmpty();
    }

    private static String createLink(String id, String url) {
        return "<a id='" + id + "' href='" + url + "'>";
    }

    private String createFavouriteLink(PortalPage portalPage) {
        StringBuilder buffer = new StringBuilder("AddFavourite.jspa?entityType=").append(portalPage.getEntityType().getName());
        buffer.append("&entityId=").append(portalPage.getId());
        buffer.append("&atl_token=").append(this.xsrfTokenGenerator.generateToken());
        buffer.append("&returnUrl=").append(JiraUrlCodec.encode((String)("Dashboard.jspa?selectPageId=" + portalPage.getId())));
        return Dashboard.createLink("dashmsg_favourite", buffer.toString());
    }

    private String createUnfavouriteLink(PortalPage portalPage) {
        StringBuilder buffer = new StringBuilder("RemoveFavourite.jspa?entityType=").append(portalPage.getEntityType().getName());
        buffer.append("&entityId=").append(portalPage.getId());
        buffer.append("&atl_token=").append(this.xsrfTokenGenerator.generateToken());
        buffer.append("&returnUrl=").append("Dashboard.jspa");
        return Dashboard.createLink("dashmsg_unfavourite", buffer.toString());
    }

    private String createManageDashboardLinkShowMyTab() {
        return Dashboard.createLink("dashmsg_managedashboard", "ConfigurePortalPages!default.jspa?view=my");
    }

    private boolean doesUserOwnPages() {
        if (this.currentUserOwnPages == null) {
            Collection portalPages;
            ApplicationUser user = this.getLoggedInUser();
            this.currentUserOwnPages = user == null ? Boolean.FALSE : Boolean.valueOf((portalPages = this.portalPageService.getOwnedPortalPages(user)) != null && !portalPages.isEmpty());
        }
        return this.currentUserOwnPages;
    }

    private boolean isUserCurrentPageOwner(PortalPage currentPortalPage) {
        return currentPortalPage != null && currentPortalPage.getOwner() != null && currentPortalPage.getOwner().equals((Object)this.getLoggedInUser());
    }

    private void initialiseCurrentDashboardId() {
        if (this.currentDashboardId != null) {
            return;
        }
        if (this.selectPageId != null) {
            this.currentDashboardId = this.selectPageId;
        } else {
            Long pageId;
            if (this.getLoggedInUser() != null) {
                List history = this.userHistoryManager.getHistory(UserHistoryItem.DASHBOARD, this.getLoggedInUser());
                if (history.isEmpty()) {
                    pageId = this.getPageIdForUser();
                    this.userHistoryManager.addItemToHistory(UserHistoryItem.DASHBOARD, this.getLoggedInUser(), String.valueOf(pageId));
                } else {
                    pageId = Long.valueOf(((UserHistoryItem)history.get(0)).getEntityId());
                    PortalPage portalPage = this.portalPageService.getPortalPage((JiraServiceContext)new JiraServiceContextImpl(this.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection()), pageId);
                    if (portalPage == null || !this.portalPageService.isFavourite(this.getLoggedInUser(), portalPage)) {
                        pageId = this.getPageIdForUser();
                        this.userHistoryManager.addItemToHistory(UserHistoryItem.DASHBOARD, this.getLoggedInUser(), String.valueOf(pageId));
                    }
                }
            } else {
                pageId = this.portalPageService.getSystemDefaultPortalPage().getId();
            }
            if (pageId != null) {
                this.currentDashboardId = pageId;
            } else {
                this.addErrorMessage("dashboard.no.default.dashboard");
            }
        }
    }

    private boolean isSystemDashboardId(Long dashboardId) {
        if (dashboardId == null) {
            return false;
        }
        PortalPage defaultPortalPage = this.portalPageService.getSystemDefaultPortalPage();
        return defaultPortalPage != null && defaultPortalPage.getId().equals(dashboardId);
    }

    private Long getPageIdForUser() {
        List<DashboardTab> tabs = this.getUserTabs();
        if (tabs != null && !tabs.isEmpty()) {
            return Long.valueOf(tabs.get(0).getDashboardId().toString());
        }
        return this.portalPageService.getSystemDefaultPortalPage().getId();
    }

    private List<DashboardTab> getUserTabs() {
        if (this.userTabs == null) {
            this.userTabs = CollectionUtil.transform((Iterable)this.portalPageService.getFavouritePortalPages(this.getLoggedInUser()), (Function)new Function<PortalPage, DashboardTab>(){

                public DashboardTab get(PortalPage dashboard) {
                    return Dashboard.this.createDashboardTab(dashboard);
                }
            });
        }
        return this.userTabs;
    }

    private DashboardTab createDashboardTab(PortalPage dashboard) {
        return new DashboardTab(DashboardId.valueOf((String)Long.toString(dashboard.getId())), dashboard.getName(), URI.create("Dashboard.jspa?selectPageId=" + dashboard.getId()));
    }

    private String getUsername() {
        ApplicationUser remoteUser = this.getLoggedInUser();
        if (remoteUser != null) {
            return remoteUser.getUsername();
        }
        return null;
    }
}

