/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleAdminService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.landingpage.RenaissanceMigrationPageRedirect;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class RenaissanceMigrationSummaryAction
extends JiraWebActionSupport {
    public static final String URL_JIRA_HOME = "/secure/MyJiraHome.jspa";
    private final ApplicationManager applicationManager;
    private final ApplicationProperties applicationProperties;
    private final RenaissanceMigrationPageRedirect pageRedirect;
    private final PageBuilderService pageBuilderService;
    private final ApplicationRoleAdminService applicationRoleAdminService;
    private boolean dismiss;

    public RenaissanceMigrationSummaryAction(ApplicationManager applicationManager, ApplicationProperties applicationProperties, RenaissanceMigrationPageRedirect pageRedirect, PageBuilderService pageBuilderService, ApplicationRoleAdminService applicationRoleAdminService) {
        this.applicationManager = applicationManager;
        this.applicationProperties = applicationProperties;
        this.pageRedirect = pageRedirect;
        this.pageBuilderService = pageBuilderService;
        this.applicationRoleAdminService = applicationRoleAdminService;
    }

    protected String doExecute() throws Exception {
        if (this.dismiss) {
            this.applicationProperties.setOption("post.migration.page.displayed", true);
            this.pageRedirect.unregisterSelf();
            return this.getRedirect(URL_JIRA_HOME);
        }
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:renaissance-migration");
        return super.doExecute();
    }

    public boolean isDismiss() {
        return this.dismiss;
    }

    public void setDismiss(boolean dismiss) {
        this.dismiss = dismiss;
    }

    @ActionViewData(value="success")
    public Map<String, Object> getData() {
        Application application = StreamSupport.stream(this.applicationManager.getApplications().spliterator(), false).filter(app -> !ApplicationKeys.CORE.equals((Object)app.getKey())).findFirst().orElseGet(() -> ((ApplicationManager)this.applicationManager).getPlatform());
        return MapBuilder.newBuilder().add((Object)"productName", (Object)application.getName()).add((Object)"productVersion", (Object)application.getVersion()).add((Object)"notMigratedGroups", this.notMigratedGroups()).add((Object)"notDefinedRoles", this.notDefinedRoles()).toMap();
    }

    private Collection<ApplicationRole> notDefinedRoles() {
        return (Collection)Optional.ofNullable(this.applicationRoleAdminService.getRoles().get()).orElse(Collections.emptySet()).stream().filter(ar -> !ar.isDefined()).sorted(Comparator.comparing(ApplicationRole::getName)).collect(CollectorsUtil.toImmutableList());
    }

    private ImmutableList<String> notMigratedGroups() {
        return (ImmutableList)Optional.ofNullable(this.applicationProperties.getString("renaissance.migration.servicedesk.not.migrated.groups")).map(groups -> groups.split(",")).map(Arrays::asList).orElse(Collections.emptyList()).stream().map(String::trim).collect(CollectorsUtil.toImmutableList());
    }
}

