/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractProjectRole;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;

@WebSudoRequired
public class EditProjectRole
extends AbstractProjectRole {
    private String name;
    private String description;

    public EditProjectRole(ProjectRoleService projectRoleService) {
        super(projectRoleService);
    }

    public String doDefault() throws Exception {
        ProjectRole roleType = this.getRole();
        this.name = roleType.getName();
        this.description = roleType.getDescription();
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getRole() == null) {
            this.addErrorMessage(this.getText("admin.errors.specified.role.does.not.exist"));
        }
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.errors.must.specify.name"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ProjectRole oldRole = this.getRole();
        ProjectRoleImpl role = new ProjectRoleImpl(oldRole.getId(), this.name, this.description);
        this.projectRoleService.updateProjectRole((ProjectRole)role, (ErrorCollection)this);
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("ViewProjectRoles.jspa");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

