/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.jira.plugin.workflow.WorkflowValidatorModuleDescriptor;
import com.atlassian.jira.web.action.admin.workflow.AbstractAddWorkflowTransitionDescriptorParams;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Map;

@WebSudoRequired
public class AddWorkflowTransitionValidatorParams
extends AbstractAddWorkflowTransitionDescriptorParams {
    private String currentValidatorCount;

    public AddWorkflowTransitionValidatorParams(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    public AddWorkflowTransitionValidatorParams(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
    }

    @Override
    protected void addWorkflowDescriptor() throws WorkflowException {
        ValidatorDescriptor validatorDescriptor = DescriptorFactory.getFactory().createValidatorDescriptor();
        validatorDescriptor.setType("class");
        Map validatorArgs = validatorDescriptor.getArgs();
        validatorArgs.put("class.name", this.getDescriptor().getImplementationClass().getName());
        WorkflowPluginValidatorFactory workflowPluginValidatorFactory = (WorkflowPluginValidatorFactory)this.getDescriptor().getModule();
        validatorArgs.putAll(workflowPluginValidatorFactory.getDescriptorParams(this.getDescriptorParams()));
        if (this.getTransition().getValidators() == null) {
            throw new InfrastructureException("Validators collection is null for workflow '" + this.getWorkflow().getName() + "' step '" + this.getStep().getName() + "' transition '" + this.getTransition().getName() + "'.");
        }
        this.getTransition().getValidators().add(validatorDescriptor);
        this.currentValidatorCount = "" + this.getTransition().getValidators().size();
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
    }

    @Override
    protected String getRedirectUrl() {
        if (TextUtils.stringSet((String)this.currentValidatorCount)) {
            return super.getRedirectUrl() + "&currentCount=workflow-validator" + this.currentValidatorCount;
        }
        return super.getRedirectUrl();
    }

    @Override
    public String getWorkflowDescriptorName() {
        return "Validator";
    }

    @Override
    protected Class getWorkflowModuleDescriptorClass() {
        return WorkflowValidatorModuleDescriptor.class;
    }
}

