/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.jira.web.action.issue.Assignable;
import com.opensymphony.util.TextUtils;

public abstract class AbstractCommentableAssignableIssue
extends AbstractCommentableIssue
implements Assignable {
    private String assignee;

    protected AbstractCommentableAssignableIssue(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, (FieldManager)ComponentAccessor.getComponent(FieldManager.class), (ProjectRoleManager)ComponentAccessor.getComponent(ProjectRoleManager.class), commentService, userUtil);
    }

    public String doDefault() throws Exception {
        this.assignee = this.getIssue().getString("assignee");
        return "input";
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (this.assigneeChanged()) {
            if (this.hasAssigneePermission(this.getAssignIn())) {
                if (this.getAssignee() != null) {
                    ApplicationUser assigneeUser = this.userUtil.getUserByKey(this.getAssignee());
                    if (assigneeUser != null) {
                        if (!ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ASSIGNABLE_USER, this.getAssignIn(), assigneeUser)) {
                            this.addError("assignee", this.getText("admin.errors.issues.user.cannot.be.assigned", assigneeUser.getUsername()));
                        }
                    } else {
                        this.addError("assignee", this.getText("admin.errors.issues.user.does.not.exit", this.getAssignee()));
                    }
                } else if (!this.getApplicationProperties().getOption("jira.option.allowunassigned")) {
                    this.log.info((Object)"Validation error: Issues must be assigned");
                    this.addError("assignee", this.getText("admin.errors.issues.must.be.assigned"));
                }
            } else {
                this.addErrorMessage(this.getText("admin.errors.issues.no.permission"));
            }
        }
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public void setAssignee(String assignee) {
        this.assignee = TextUtils.stringSet((String)assignee) ? assignee : null;
    }

    @Override
    public Project getAssignIn() {
        return this.getProjectObject();
    }

    protected boolean assigneeChanged() {
        String originalAssignee = this.getIssue().getString("assignee");
        return !(originalAssignee == null && this.getAssignee() == null || originalAssignee != null && originalAssignee.equals(this.getAssignee()));
    }

    protected boolean hasAssigneePermission(Project project) {
        return ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ASSIGN_ISSUES, project, this.getLoggedInUser());
    }
}

