/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.util.UtilDateTime;

public class AddComment
extends AbstractCommentableIssue
implements OperationContext {
    protected final PermissionManager permissionManager;
    private final IssueEventManager issueEventManager;
    private final IssueEventBundleFactory issueEventBundleFactory;

    public AddComment(SubTaskManager subTaskManager, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, ProjectRoleManager projectRoleManager, CommentService commentService, PermissionManager permissionManager, UserUtil userUtil, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.permissionManager = permissionManager;
        this.issueEventManager = issueEventManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
    }

    public String doDefault() {
        try {
            if (!this.isAbleToComment()) {
                return "error";
            }
        }
        catch (IssueNotFoundException e) {
            this.getErrorMessages().clear();
            return "error";
        }
        catch (IssuePermissionException ipe) {
            this.getErrorMessages().clear();
            return "error";
        }
        return "input";
    }

    public boolean isAbleToComment() {
        return this.getIssue() == null ? this.permissionManager.hasPermission(15, this.getIssueObject().getProjectObject(), this.getLoggedInUser()) : this.permissionManager.hasPermission(15, this.getIssueObject(), this.getLoggedInUser());
    }

    @Override
    protected void doValidation() {
        try {
            super.doCommentValidation(false);
        }
        catch (IssueNotFoundException issueNotFoundException) {
        }
        catch (IssuePermissionException issuePermissionException) {
            // empty catch block
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Comment comment = this.createComment();
        this.alertSystemOfComment(comment);
        if (StringUtils.isNotBlank((String)this.getReturnUrl())) {
            return this.returnCompleteWithInlineRedirect(this.getReturnUrl());
        }
        String browseIssue = "/browse/" + this.getIssue().getString("key");
        if (comment != null) {
            return this.returnComplete(browseIssue + "?focusedCommentId=" + comment.getId() + "#comment-" + comment.getId());
        }
        return this.returnComplete(browseIssue);
    }

    @VisibleForTesting
    void alertSystemOfComment(Comment comment) throws GenericEntityException {
        MutableIssue issueObject = this.getMutableIssue();
        issueObject.setUpdated(UtilDateTime.nowTimestamp());
        issueObject.store();
        Map<String, Object> params = this.createIssueEventParameters();
        this.issueEventManager.dispatchRedundantEvent(EventType.ISSUE_COMMENTED_ID, (Issue)issueObject, this.getLoggedInUser(), comment, null, null, params);
        IssueEventBundle issueCommentBundle = this.issueEventBundleFactory.createCommentAddedBundle((Issue)issueObject, this.getLoggedInUser(), comment, params);
        this.issueEventManager.dispatchEvent(issueCommentBundle);
    }

    private Map<String, Object> createIssueEventParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eventsource", "action");
        return params;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

