/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.adapter.jackson.ObjectMapper;
import com.atlassian.fugue.Either;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.compress.utils.IOUtils;
import webwork.action.ServletActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class AttachTemporaryFile
extends AbstractIssueSelectAction {
    public static final String TEMP_FILENAME = "tempFilename";
    private final transient TemporaryWebAttachmentManager temporaryWebAttachmentManager;
    private final transient ObjectMapper objectMapper;
    protected final transient IssueUpdater issueUpdater;
    protected final transient ApplicationProperties applicationProperties;
    private boolean create = false;
    private Long projectId;
    private String formToken;
    private TemporaryWebAttachment temporaryWebAttachment;

    public AttachTemporaryFile(SubTaskManager subTaskManager, TemporaryWebAttachmentManager temporaryWebAttachmentManager, ObjectMapper objectMapper, IssueUpdater issueUpdater, ApplicationProperties applicationProperties) {
        super(subTaskManager);
        this.temporaryWebAttachmentManager = temporaryWebAttachmentManager;
        this.objectMapper = objectMapper;
        this.issueUpdater = issueUpdater;
        this.applicationProperties = applicationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        MultiPartRequestWrapper multipart = this.getMultipart();
        String filename = multipart.getFilesystemName(TEMP_FILENAME);
        String contentType = multipart.getContentType(TEMP_FILENAME);
        File file = multipart.getFile(TEMP_FILENAME);
        if (file == null) {
            this.addErrorMessage(this.getText("attachfile.error.file.zero", filename), ErrorCollection.Reason.VALIDATION_FAILED);
            return "temp_file_json";
        }
        try {
            this.createTemporaryAttachment(filename, contentType, file);
            if (file.delete()) return "temp_file_json";
        }
        catch (Throwable throwable) {
            if (file.delete()) throw throwable;
            this.log.warn((Object)String.format("Unable to delete temporary attachment file %s", file.getName()));
            throw throwable;
        }
        this.log.warn((Object)String.format("Unable to delete temporary attachment file %s", file.getName()));
        return "temp_file_json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemporaryAttachment(String filename, String contentType, File file) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            Either target = this.isCreate() ? Either.right((Object)this.getProjectObject()) : Either.left((Object)this.getIssueObject());
            Either result = this.temporaryWebAttachmentManager.createTemporaryWebAttachment((InputStream)inputStream, filename, contentType, file.length(), target, this.getFormToken(), this.getLoggedInUser());
            this.temporaryWebAttachment = (TemporaryWebAttachment)result.right().on((Function)new Function<AttachmentError, TemporaryWebAttachment>(){

                public TemporaryWebAttachment apply(AttachmentError error) {
                    AttachTemporaryFile.this.addErrorMessage(error.getLocalizedMessage(), error.getReason());
                    return null;
                }
            });
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    @Override
    public String getFormToken() {
        return this.formToken;
    }

    @Override
    public void setFormToken(String formToken) {
        this.formToken = formToken;
    }

    protected MultiPartRequestWrapper getMultipart() {
        return ServletActionContext.getMultiPartRequest();
    }

    public String getResponseAsJson() {
        if (this.hasAnyErrors()) {
            return this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"errorMsg", (Object)this.getErrorMessage()));
        }
        return this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"id", (Object)this.temporaryWebAttachment.getStringId(), (Object)"name", (Object)this.temporaryWebAttachment.getFilename()));
    }

    @Override
    public Project getProjectObject() {
        if (this.projectId != null) {
            return this.getProjectManager().getProjectObj(this.projectId);
        }
        return null;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getErrorMessage() {
        if (!this.getErrorMessages().isEmpty()) {
            StringBuilder errorMsgs = new StringBuilder();
            Iterator errorIterator = this.getErrorMessages().iterator();
            while (errorIterator.hasNext()) {
                String error = (String)errorIterator.next();
                errorMsgs.append(error);
                if (!errorIterator.hasNext()) continue;
                errorMsgs.append(", ");
            }
            return errorMsgs.toString();
        }
        return "";
    }
}

