/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.jira.application.ApplicationConfigurationHelper;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.SetupAdminUserSessionStorage;
import com.atlassian.jira.web.action.setup.SetupLicenseSessionStorage;
import com.google.common.base.Strings;
import java.util.Collections;

public class SetupAdminAccount
extends AbstractSetupAction {
    final ApplicationConfigurationHelper appConfigHelper;
    private final UserService userService;
    private final GroupManager groupManager;
    private final UserUtil userUtil;
    private final JiraLicenseService jiraLicenseService;
    private final JiraWebResourceManager webResourceManager;
    private final GlobalPermissionManager globalPermissionManager;
    String username;
    String fullname;
    String firstname;
    String lastname;
    String email;
    String password;
    String confirm;
    private String EXISTING_ADMINS = "existingadmins";
    private UserService.CreateUserValidationResult result;

    public SetupAdminAccount(UserService userService, GroupManager groupManager, UserUtil userUtil, FileFactory fileFactory, JiraLicenseService jiraLicenseService, JiraWebResourceManager webResourceManager, JiraProperties jiraProperties, GlobalPermissionManager globalPermissionManager, JiraProductInformation jiraProductInformation, ApplicationConfigurationHelper appConfigHelper) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.userService = userService;
        this.groupManager = groupManager;
        this.userUtil = userUtil;
        this.jiraLicenseService = jiraLicenseService;
        this.webResourceManager = webResourceManager;
        this.globalPermissionManager = (GlobalPermissionManager)Assertions.notNull((String)"globalPermissionManager", (Object)globalPermissionManager);
        this.appConfigHelper = (ApplicationConfigurationHelper)Assertions.notNull((String)"appConfigHelper", (Object)appConfigHelper);
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.userUtil.getJiraAdministrators().size() > 0) {
            return this.EXISTING_ADMINS;
        }
        this.prePopulateFields();
        this.putSENIntoMetadata();
        return super.doDefault();
    }

    private void prePopulateFields() {
        SetupLicenseSessionStorage sessionStorage = (SetupLicenseSessionStorage)this.request.getSession().getAttribute(SetupLicenseSessionStorage.SESSION_KEY);
        this.request.getSession().removeAttribute(SetupLicenseSessionStorage.SESSION_KEY);
        if (sessionStorage != null) {
            this.firstname = Strings.nullToEmpty((String)sessionStorage.getFirstName());
            this.lastname = Strings.nullToEmpty((String)sessionStorage.getLastName());
            this.email = Strings.nullToEmpty((String)sessionStorage.getEmail());
            if (Strings.isNullOrEmpty((String)this.fullname)) {
                this.fullname = (this.firstname + ' ' + this.lastname).trim();
            }
            if (!Strings.isNullOrEmpty((String)this.firstname) && !Strings.isNullOrEmpty((String)this.lastname)) {
                this.username = (this.firstname.charAt(0) + this.lastname).replaceAll("\\s", "").toLowerCase();
            }
        }
    }

    protected void doValidation() {
        if (this.setupAlready()) {
            return;
        }
        String adminUsername = this.getUsername() != null ? this.getUsername().trim() : this.getUsername();
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)this.getLoggedInUser(), (String)adminUsername, (String)this.getPassword(), (String)this.getEmail(), (String)this.getFullname()).confirmPassword(this.getConfirm()).passwordRequired().performPermissionCheck(false).sendNotification(false);
        this.result = this.userService.validateCreateUser(createUserRequest);
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
    }

    protected String doExecute() {
        block10: {
            if (this.setupAlready()) {
                return "setupalready";
            }
            ApplicationUser administrator = null;
            try {
                if (!this.userUtil.getJiraAdministrators().isEmpty()) {
                    return this.EXISTING_ADMINS;
                }
                try {
                    administrator = this.userService.createUser(this.result);
                }
                catch (PermissionException e) {
                    this.addErrorMessage(this.getText("signup.error.group.database.immutable", this.result.getUsername()));
                }
                Group groupAdmins = this.getOrCreateGroup("jira-administrators");
                if (administrator == null || groupAdmins == null) break block10;
                try {
                    if (!this.groupManager.isUserInGroup(administrator, groupAdmins)) {
                        this.groupManager.addUserToGroup(administrator, groupAdmins);
                    }
                }
                catch (CrowdException e) {
                    throw new RuntimeException(e);
                }
                if (!this.globalPermissionManager.getGroupNames(0).contains("jira-administrators")) {
                    this.globalPermissionManager.addPermission(0, "jira-administrators");
                }
                this.appConfigHelper.configureApplicationsForSetup(Collections.singleton(groupAdmins), true);
                this.appConfigHelper.setupAdminForDefaultApplications(administrator);
            }
            catch (CreateException e) {
                throw new RuntimeException(e);
            }
        }
        this.request.getSession().setAttribute(SetupAdminUserSessionStorage.SESSION_KEY, (Object)new SetupAdminUserSessionStorage(this.result.getUsername()));
        this.putSENIntoMetadata();
        return this.getResult();
    }

    private Group getOrCreateGroup(String groupName) {
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            return group;
        }
        try {
            return this.groupManager.createGroup(groupName);
        }
        catch (OperationNotPermittedException | InvalidGroupException e) {
            this.addErrorMessage(this.getText("signup.error.group.database.immutable", groupName));
            return null;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    private void putSENIntoMetadata() {
        if (!this.jiraLicenseService.getSupportEntitlementNumbers().isEmpty()) {
            this.webResourceManager.putMetadata("SEN", (String)this.jiraLicenseService.getSupportEntitlementNumbers().first());
        }
    }
}

