/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.ImportTaskManager;
import com.atlassian.jira.task.ImportTaskManagerImpl;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.DataImportAsyncCommand;
import com.atlassian.jira.web.action.setup.PostSetupURIProvider;
import com.atlassian.jira.web.action.util.ImportResultHandler;
import com.atlassian.jira.web.servletcontext.ServletContextReference;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.ImmutableMap;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class SetupImport
extends AbstractSetupAction {
    private static final String PROGRESS_URL = "/importprogress?setup=true";
    private static ServletContextReference<ImportTaskManager> taskManagerReference = new ServletContextReference("jira.import.task.manager");
    private final IndexPathManager indexPathManager;
    private final ExternalLinkUtil externalLinkUtil;
    private final BuildUtilsInfo buildUtilsInfo;
    private final DataImportService dataImportService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final MailSettings mailSettings;
    private final PostSetupURIProvider postSetupURIProvider;
    private ImportResultHandler importResultHandler;
    private String filename;
    private String license;
    private boolean useDefaultPaths;
    private boolean outgoingEmail = false;
    private ErrorCollection specificErrors;
    private boolean downgradeAnyway;
    private final JohnsonProvider johnsonProvider;

    public SetupImport(IndexPathManager indexPathManager, ExternalLinkUtil externalLinkUtil, BuildUtilsInfo buildUtilsInfo, FileFactory fileFactory, DataImportService dataImportService, ImportResultHandler importResultHandler, VelocityRequestContextFactory velocityRequestContextFactory, MailSettings mailSettings, PostSetupURIProvider postSetupURIProvider, JiraProperties jiraProperties, JohnsonProvider johnsonProvider, JiraProductInformation jiraProductInformation) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.dataImportService = dataImportService;
        this.importResultHandler = importResultHandler;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.mailSettings = mailSettings;
        this.johnsonProvider = johnsonProvider;
        this.postSetupURIProvider = (PostSetupURIProvider)Assertions.notNull((String)"postSetupURIProvider", (Object)postSetupURIProvider);
        this.indexPathManager = (IndexPathManager)Assertions.notNull((String)"indexPathManager", (Object)indexPathManager);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    public String doFetchLicense() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        ActionContext.getSession().put("jira.setup.xml", this.filename);
        return "input";
    }

    public String doReturnFromMAC() throws Exception {
        this.filename = ActionContext.getSession().get("jira.setup.xml") == null ? "" : ActionContext.getSession().get("jira.setup.xml").toString();
        return "input";
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        ActionContext.getSession().remove("jira.data.import.result");
        this.outgoingEmail = this.mailSettings.send().isEnabled();
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.setupAlready()) {
            return;
        }
        DataImportService.ImportResult lastResult = (DataImportService.ImportResult)ActionContext.getSession().get("jira.data.import.result");
        if (lastResult == null) {
            DataImportParams params = this.buildDataImportParameters();
            DataImportService.ImportValidationResult result = this.dataImportService.validateImport(this.getLoggedInUser(), params);
            if (!result.isValid()) {
                this.addErrorCollection(result.getErrorCollection());
            }
        }
    }

    private JiraLicenseService getLicenseService() {
        return (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
    }

    protected String doExecute() throws Exception {
        DataImportService.ImportResult lastResult = (DataImportService.ImportResult)ActionContext.getSession().get("jira.data.import.result");
        if (lastResult != null) {
            return this.checkImportResult(lastResult);
        }
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.thereIsAnActiveTaskManager()) {
            return this.getRedirect(this.getProgressUrl());
        }
        taskManagerReference.set(new ImportTaskManagerImpl());
        JohnsonEventContainer eventCont = this.johnsonProvider.getContainer();
        try {
            DataImportParams params = this.buildDataImportParameters();
            DataImportService.ImportValidationResult result = this.dataImportService.validateImport(this.getLoggedInUser(), params);
            DataImportAsyncCommand importCallable = new DataImportAsyncCommand(eventCont, this.dataImportService, this.getLoggedInUser(), result, new Event(EventType.get((String)"setup"), "JIRA is currently being set up", EventLevel.get((String)"warning")), this.velocityRequestContextFactory.getJiraVelocityRequestContext(), ActionContext.getRequest().getSession(false));
            Locale locale = ((JiraAuthenticationContext)this.getComponentInstanceOfType(JiraAuthenticationContext.class)).getLocale();
            taskManagerReference.get().submitTask(importCallable, this.getText("setup.import.title"));
            taskManagerReference.get().prepareCachedResourceBundleStrings(locale);
            return this.getRedirect(this.getProgressUrl());
        }
        catch (AlreadyExecutingException e) {
            return this.getRedirect(this.getProgressUrl());
        }
        catch (RejectedExecutionException e) {
            this.addErrorMessage(this.getText("common.tasks.rejected.execution.exception", e.getMessage()));
            return "error";
        }
    }

    private boolean thereIsAnActiveTaskManager() {
        return taskManagerReference.get() != null && taskManagerReference.get().getTask() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkImportResult(DataImportService.ImportResult lastResult) throws URISyntaxException {
        try {
            if (!lastResult.isValid()) {
                this.filename = lastResult.getParams().getFilename();
                this.useDefaultPaths = lastResult.getParams().isUseDefaultPaths();
                this.license = lastResult.getParams().getLicenseString();
                this.addErrorCollection(lastResult.getErrorCollection());
                this.specificErrors = new SimpleErrorCollection();
                if (this.importResultHandler.handleErrorResult(lastResult, (I18nHelper)this, this.specificErrors)) {
                    String string = this.getRedirect(this.johnsonProvider.getConfig().getErrorPath());
                    return string;
                }
                String string = "error";
                return string;
            }
            String postSetupURI = this.postSetupURIProvider.getPostSetupRedirect((Option<String>)Option.some((Object)SetupImport.class.getSimpleName()));
            String string = this.getRedirect(postSetupURI);
            return string;
        }
        finally {
            ActionContext.getSession().remove("jira.data.import.result");
        }
    }

    private DataImportParams buildDataImportParameters() {
        DataImportParams.Builder builder = new DataImportParams.Builder(this.filename).setLicenseString(this.license).setUseDefaultPaths(this.useDefaultPaths).setAllowDowngrade(this.downgradeAnyway).setupImport();
        if (this.isOutgoingMailModifiable()) {
            builder.setOutgoingEmailTo(this.outgoingEmail);
        }
        return builder.build();
    }

    private String getProgressUrl() {
        return "/importprogress?setup=true&locale=" + this.getLocale().toString();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDefaultIndexPath() {
        return this.indexPathManager.getDefaultIndexRootPath();
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public boolean isUseDefaultPaths() {
        return this.useDefaultPaths;
    }

    public void setUseDefaultPaths(boolean useDefaultPaths) {
        this.useDefaultPaths = useDefaultPaths;
    }

    public boolean hasSpecificErrors() {
        return this.specificErrors != null && this.specificErrors.hasAnyErrors();
    }

    public ErrorCollection getSpecificErrors() {
        return this.specificErrors;
    }

    public boolean isDowngradeAnyway() {
        return this.downgradeAnyway;
    }

    public void setDowngradeAnyway(boolean downgradeAnyway) {
        this.downgradeAnyway = downgradeAnyway;
    }

    public String getRequestLicenseURL() {
        StringBuilder url = new StringBuilder();
        url.append(JiraUrl.constructBaseUrl((HttpServletRequest)this.request));
        url.append("/secure/SetupImport!returnFromMAC.jspa");
        return this.externalLinkUtil.getProperty("external.link.jira.license.view", Arrays.asList(this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), "enterprise", this.getServerId(), url.toString()));
    }

    public void setOutgoingEmail(boolean outgoingEmail) {
        this.outgoingEmail = outgoingEmail;
    }

    public boolean isOutgoingMailModifiable() {
        return this.mailSettings.send().isModifiable();
    }

    public Map<String, String> getOutgoingMailOptions() {
        return ImmutableMap.of((Object)"true", (Object)"Enable", (Object)"false", (Object)"Disable");
    }

    public boolean outgoingEmail() {
        return this.outgoingEmail;
    }
}

